var mapStyles = {
    'silver': [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#f5f5f5"
                }
            ]
        },
        {
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#f5f5f5"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#bdbdbd"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#eeeeee"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#e5e5e5"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#ffffff"
                }
            ]
        },
        {
            "featureType": "road.arterial",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dadada"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#e5e5e5"
                }
            ]
        },
        {
            "featureType": "transit.station",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#eeeeee"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#c9c9c9"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        }
    ],
    'retro': [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#ebe3cd"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#523735"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#f5f1e6"
                }
            ]
        },
        {
            "featureType": "administrative",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#c9b2a6"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#dcd2be"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#ae9e90"
                }
            ]
        },
        {
            "featureType": "landscape.natural",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dfd2ae"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dfd2ae"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#93817c"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#a5b076"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#447530"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#f5f1e6"
                }
            ]
        },
        {
            "featureType": "road.arterial",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#fdfcf8"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#f8c967"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#e9bc62"
                }
            ]
        },
        {
            "featureType": "road.highway.controlled_access",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#e98d58"
                }
            ]
        },
        {
            "featureType": "road.highway.controlled_access",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#db8555"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#806b63"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dfd2ae"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#8f7d77"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#ebe3cd"
                }
            ]
        },
        {
            "featureType": "transit.station",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#dfd2ae"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#b9d3c2"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#92998d"
                }
            ]
        }
    ],
    'dark': [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#212121"
                }
            ]
        },
        {
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#212121"
                }
            ]
        },
        {
            "featureType": "administrative",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "administrative.country",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9e9e9e"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "administrative.locality",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#bdbdbd"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#181818"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#1b1b1b"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#2c2c2c"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#8a8a8a"
                }
            ]
        },
        {
            "featureType": "road.arterial",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#373737"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#3c3c3c"
                }
            ]
        },
        {
            "featureType": "road.highway.controlled_access",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#4e4e4e"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#616161"
                }
            ]
        },
        {
            "featureType": "transit",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#757575"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#000000"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#3d3d3d"
                }
            ]
        }
    ],
    'night': [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#242f3e"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#746855"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#242f3e"
                }
            ]
        },
        {
            "featureType": "administrative.locality",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#d59563"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#d59563"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#263c3f"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#6b9a76"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#38414e"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#212a37"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#9ca5b3"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#746855"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#1f2835"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#f3d19c"
                }
            ]
        },
        {
            "featureType": "transit",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#2f3948"
                }
            ]
        },
        {
            "featureType": "transit.station",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#d59563"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#17263c"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#515c6d"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#17263c"
                }
            ]
        }
    ],
    'aubergine': [
        {
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#1d2c4d"
                }
            ]
        },
        {
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#8ec3b9"
                }
            ]
        },
        {
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#1a3646"
                }
            ]
        },
        {
            "featureType": "administrative.country",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#4b6878"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#64779e"
                }
            ]
        },
        {
            "featureType": "administrative.province",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#4b6878"
                }
            ]
        },
        {
            "featureType": "landscape.man_made",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#334e87"
                }
            ]
        },
        {
            "featureType": "landscape.natural",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#023e58"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#283d6a"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#6f9ba5"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#1d2c4d"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#023e58"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#3C7680"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#304a7d"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#98a5be"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#1d2c4d"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#2c6675"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#255763"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#b0d5ce"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#023e58"
                }
            ]
        },
        {
            "featureType": "transit",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#98a5be"
                }
            ]
        },
        {
            "featureType": "transit",
            "elementType": "labels.text.stroke",
            "stylers": [
                {
                    "color": "#1d2c4d"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#283d6a"
                }
            ]
        },
        {
            "featureType": "transit.station",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#3a4762"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#0e1626"
                }
            ]
        },
        {
            "featureType": "water",
            "elementType": "labels.text.fill",
            "stylers": [
                {
                    "color": "#4e6d70"
                }
            ]
        }
    ]
};
var getHeightHiddenEl = function (el) {
    var el_style = window.getComputedStyle(el),
        el_display = el_style.display,
        el_position = el_style.position,
        el_visibility = el_style.visibility,
        el_max_height = el_style.maxHeight.replace('px', '').replace('%', ''),
        wanted_height = 0;
    // if its not hidden we just return normal height
    if (el_display !== 'none' && el_max_height !== '0') {
        return el.offsetHeight;
    }
    // the element is hidden so:
    // making the el block so we can meassure its height but still be hidden
    el.style.position = 'absolute';
    el.style.visibility = 'hidden';
    el.style.display = 'block';
    wanted_height = el.offsetHeight;
    // reverting to the original values
    el.style.display = '';
    el.style.position = 'relative';
    el.style.visibility = 'visible';
    return wanted_height;
};
(function ($) {
    'use strict';
    var body = $('body');
    if ($('.has-matchHeight', body).length) {
        $('.has-matchHeight', body).matchHeight();
    }
    if ($('.dropdown-toggle', body).length) {
        $('.dropdown-toggle', body).dropdown();
    }
    $('.open-loss-password', body).click(function (ev) {
        ev.preventDefault();
        $('#st-login-form', body).modal('hide');
        $('#st-register-form', body).modal('hide');
        setTimeout(function () {
            $('#st-forgot-form', body).modal('show');
        }, 500);
    });
    $('.open-login', body).click(function (ev) {
        ev.preventDefault();
        $('#st-register-form', body).modal('hide');
        $('#st-forgot-form', body).modal('hide');
        setTimeout(function () {
            $('#st-login-form', body).modal('show');
        }, 500);
    });
    $('.open-signup', body).click(function (ev) {
        ev.preventDefault();
        $('#st-forgot-form', body).modal('hide');
        $('#st-login-form', body).modal('hide');
        setTimeout(function () {
            $('#st-register-form', body).modal('show');
        }, 500);
    });
    $('[data-toggle="tooltip"]').tooltip();
    $('.toggle-menu').click(function (ev) {
        ev.preventDefault();
        toggleBody($('#st-main-menu'));
        $('#st-main-menu').toggleClass('open');
    });
    $('.back-menu').click(function (ev) {
        ev.preventDefault();
        toggleBody($('#st-main-menu'));
        $('#st-main-menu').toggleClass('open');
    });
    function toggleBody(el) {
        if (el.hasClass('open')) {
            body.css({
                'overflow': ''
            });
        } else {
            body.css({
                'overflow': 'hidden'
            });
        }
    }
    $('#st-main-menu .main-menu .menu-item-has-children .fa').click(function () {
        if (window.matchMedia("(max-width: 991px)").matches) {
            $(this).toggleClass('fa-angle-down fa-angle-up');
            var parent = $(this).parent();
            $('>.menu-dropdown', parent).toggle();
            if ($(this).closest('.menu-item-has-children').hasClass('has-mega-menu')) {
                $('>.mega-menu', $(this).parent().parent()).toggle();
            }
        }
    });
    body.click(function (ev) {
        if ($(ev.target).is('#st-main-menu')) {
            toggleBody($(ev.target));
            $('#st-main-menu').toggleClass('open');
        }
    });
    $(window).on('resize', function () {
        if (window.matchMedia('(min-width: 992px)').matches) {
            $('.st-gallery', body).each(function () {
                var parent = $(this);
                var $fotoramaDiv = $('.fotorama', parent).fotorama({
                    width: parent.data('width'),
                    nav: parent.data('nav'),
                    thumbwidth: '135',
                    thumbheight: '135',
                    allowfullscreen: parent.data('allowfullscreen')
                });
                parent.data('fotorama', $fotoramaDiv.data('fotorama'));
            });
        } else {
            $('.st-gallery', body).each(function () {
                var parent = $(this);
                if (typeof parent.data('fotorama') !== 'undefined') {
                    parent.data('fotorama').destroy();
                }
                var $fotoramaDiv = $('.fotorama', parent).fotorama({
                    width: parent.data('width'),
                    nav: parent.data('nav'),
                    thumbwidth: '80',
                    thumbheight: '80',
                    allowfullscreen: parent.data('allowfullscreen')
                });
                parent.data('fotorama', $fotoramaDiv.data('fotorama'));
            });
        }
        if (window.matchMedia('(min-width: 992px)').matches) {
            $('.full-map').show();
        } else {
            $('.full-map').hide();
        }
        if (window.matchMedia('(max-width: 991px)').matches) {
            $('.as').slideDown();
        }
    }).resize();
    if ($('.dropdown-toggle', body).length) {
        $('.dropdown-toggle', body).dropdown();
    }
    body.on('click', '.toggle-section', function (ev) {
        ev.preventDefault();
        var t = $(this);
        var target = t.data('target');
        $('.fa', t).toggleClass('fa-angle-up fa-angle-down');
        $('[data-toggle-section="' + target + '"]').slideToggle(200);
    });
    var timeout_fixed_item;
    $(window).on('resize', function () {
        clearTimeout(timeout_fixed_item);
        timeout_fixed_item = setTimeout(function () {
            $('.fixed-on-mobile', body).each(function () {
                var t = $(this);
                var screen = t.data('screen');
                var width = t.width(),
                    top = t.offset().top;
                $(window).scroll(function () {
                    if ($(window).scrollTop() >= top && window.matchMedia('(min-width: ' + screen + ')').matches) {
                        if (t.css('position') != 'fixed') {
                            t.css({
                                width: width,
                                position: 'fixed',
                                top: 0 + $('#wpadminbar').height(),
                                'z-index': 9
                            });
                        }
                        if ($('.stoped-scroll-section', body).length) {
                            var room_position = $('.stoped-scroll-section', body).offset().top;
                            if ($(window).scrollTop() >= room_position && t.css('position') == 'fixed') {
                                t.css({
                                    width: width,
                                    position: 'fixed',
                                    top: room_position - $(window).scrollTop(),
                                    'z-index': 9
                                });
                            } else {
                                t.css({
                                    width: width,
                                    position: 'fixed',
                                    top: 0 + $('#wpadminbar').height(),
                                    'z-index': 9
                                });
                            }
                        }
                    } else {
                        t.css({
                            position: '',
                            top: '',
                            width: 'auto',
                            'z-index': ''
                        })
                    }
                });
            });
            $('.hotel-target-book-mobile', body).each(function () {
                var t = $(this);
                $(window).scroll(function () {
                    if ($(window).scrollTop() >= 50 && window.matchMedia('(max-width: 991px)').matches) {
                        t.css('display', 'flex');
                    } else {
                        t.css('display', 'none');
                    }
                });
            });
        }, 1000);
    }).resize();
    $('[data-show-all]', body).each(function () {
        var t = $(this);
        var height = t.data('height');
        t.css('height', height);
    });
    body.on('click', '[data-show-target]', function (ev) {
        ev.preventDefault();
        var target = $(this).data('show-target');
        $('.fa', this).toggleClass('fa-caret-up fa-caret-down');
        if ($('.fa', this).hasClass('fa-caret-up')) {
            $('.text', this).html($(this).data('text-less'));
        } else {
            $('.text', this).html($(this).data('text-more'));
        }
        if ($('[data-show-all="' + target + '"]', body).hasClass('open')) {
            $('[data-show-all="' + target + '"]', body).css({height: $('[data-show-all="' + target + '"]', body).data('height')});
        } else {
            $('[data-show-all="' + target + '"]', body).css({height: ''});
        }
        $('[data-show-all="' + target + '"]', body).toggleClass('open');
    });
    $('.hotel-target-book-mobile .btn-mpopup', body).click(function (ev) {
        ev.preventDefault();
        $('.fixed-on-mobile', body).toggleClass('open').fadeToggle(300);
    });
    $('.fixed-on-mobile .close-icon', body).click(function (ev) {
        ev.preventDefault();
        $('.fixed-on-mobile', body).toggleClass('open').fadeToggle(300);
    });
    $('.review-list', body).on('click', '.show-more', function (ev) {
        ev.preventDefault();
        var parent = $(this).closest('.comment');
        $(this).css('display', 'none');
        $('.review', parent).slideDown(200);
        $('.show-less', parent).css('display', 'block');
    });
    $('.review-list', body).on('click', '.show-less', function (ev) {
        ev.preventDefault();
        var parent = $(this).closest('.comment');
        $(this).css('display', 'none');
        $('.review', parent).slideUp(200);
        $('.show-more', parent).css('display', 'block');
    });
    // Availability
    $('.st-availability', body).each(function () {
        var t = $(this);
        var container = $('.st-calendar', t);
        var calendar = $('.calendar_input', container);
        var options = {
            parentEl: container,
            showCalendar: true,
            alwaysShow: true,
            autoUpdateInput: true,
            singleDatePicker: false,
            showTodayButton: false,
            autoApply: true,
            disabledPast: true,
            responSingle: true,
            widthCalendar: 750,
            onlyShowCurrentMonth: true,
            classNotAvailable: ['disabled', 'off'],
            enableLoading: true,
            showEventTooltip: true,
            fetchEvents: function (start, end, el, callback) {
                var events = [];
                if (el.flag_get_events) {
                    return false;
                }
                el.flag_get_events = true;
                el.container.find('.loader-wrapper').show();
                var data = {
                    action: calendar.data('action'),
                    start: start.format('YYYY-MM-DD'),
                    end: end.format('YYYY-MM-DD'),
                    post_id: calendar.data('room-id'),
                    security: st_params._s
                };
                $.post(st_params.ajax_url, data, function (respon) {
                    if (typeof respon === 'object') {
                        if (typeof respon.events === 'object') {
                            events = respon.events;
                        }
                    } else {
                        console.log('Can not get data');
                    }
                    callback(events, el);
                    el.flag_get_events = false;
                    el.container.find('.loader-wrapper').hide();
                }, 'json');
            }
        };
        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        calendar.daterangepicker(options, function (start, end, label) {
        });
        var dp = calendar.data('daterangepicker');
        dp.show();
    });
    /* Price range */
    $(".price_range").each(function () {
        var min = $(this).data('min');
        var max = $(this).data('max');
        var step = $(this).data('step');
        var value = $(this).val();
        var from = value.split(';');
        var prefix_symbol = $(this).data('symbol');
        var to = from[1];
        from = from[0];
        $(this).ionRangeSlider({
            min: min,
            max: max,
            type: 'double',
            prefix: prefix_symbol,
            prettify: false,
            step: step,
            onFinish: function (data) {
                set_price_range_val(data, $('input[name="price_range"]'));
            },
            from: from,
            to: to,
            force_edges: true
        });
    });
    function set_price_range_val(data, element) {
        var exchange = 1;
        var from = Math.round(parseInt(data.from) / exchange);
        var to = Math.round(parseInt(data.to) / exchange);
        var text = from + ";" + to;
        element.val(text);
    }
    /*Sidebar toggle*/
    if ($('.sidebar-item').length) {
        $('.sidebar-item').each(function () {
            var t = $(this);
            if (t.hasClass('open')) {
                t.find('.item-content').slideUp();
            }
        });
    }
    $('.sidebar-item .item-title').on('click', function () {
        var t = $(this);
        t.parent().toggleClass('open');
        t.parent().find('.item-content').slideToggle();
    });
    /* Clear radio button */
    $('.btn-clear-review-score').on('click', function () {
        var t = $(this);
        var parent = t.closest('ul');
        parent.find('input').prop('checked', false);
    });
    /* Load more checkbox item */
    if ($('.btn-more-item').length) {
        $('.btn-more-item').each(function () {
            var t = $(this);
            var parent = t.closest('.item-content');
            if (parent.find('ul li').length > 3) {
                t.show();
            }
            t.on('click', function () {
                var countLi = parent.find('ul li.hidden').length;
                var max = 3;
                if (countLi < 3) {
                    max = countLi;
                }
                for (var i = 0; i < max; i++) {
                    parent.find('ul li.hidden').eq(0).removeClass('hidden');
                }
                var countLi = parent.find('ul li.hidden').length;
                if (countLi <= 0) {
                    t.hide();
                }
            });
        });
    }
    $('.form-date-search', body).each(function () {
        var parent = $(this),
            date_wrapper = $('.date-wrapper', parent),
            check_in_input = $('.check-in-input', parent),
            check_out_input = $('.check-out-input', parent),
            check_in_out = $('.check-in-out', parent),
            check_in_render = $('.check-in-render', parent),
            check_out_render = $('.check-out-render', parent);
        var timepicker = parent.data('timepicker');
        if(typeof timepicker == 'undefined' || timepicker == ''){
            timepicker = false;
        }else{
            timepicker =true;
        }
        var options = {
            singleDatePicker: false,
            sameDate: false,
            autoApply: true,
            disabledPast: true,
            dateFormat: 'DD/MM/YYYY',
            customClass: '',
            widthSingle: 500,
            onlyShowCurrentMonth: true,
            timePicker: timepicker,
        };
        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        check_in_out.daterangepicker(options,
            function (start, end, label) {
                check_in_input.val(start.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-in-input').val(start.format('YYYY-MM-DD'));
                check_in_render.html(start.format(parent.data('format')));
                check_out_input.val(end.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-out-input').val(end.format('YYYY-MM-DD'));
                check_out_render.html(end.format(parent.data('format')));
                if(timepicker){
                    check_in_input.val(start.format(parent.data('date-format')));
                    $('.check-in-input-time', parent).val(start.format(parent.data('time-format')));
                    check_out_input.val(end.format(parent.data('date-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));
                }
                check_in_out.trigger('daterangepicker_change', [start, end]);
                if (window.matchMedia('(max-width: 767px)').matches) {
                    $('label', parent).hide();
                    $('.render', parent).show();
                    $('.check-in-wrapper span', parent).show();
                }
            });
        date_wrapper.click(function (e) {
            check_in_out.trigger('click');
        });
    });
    $('.form-date-search.form-date-car', body).each(function () {
        var parent = $(this),
            date_wrapper = $('.date-wrapper', parent),
            check_in_input = $('.check-in-input', parent),
            check_out_input = $('.check-out-input', parent),
            check_in_out = $('.check-in-out', parent),
            check_in_render = $('.check-in-render', parent),
            check_out_render = $('.check-out-render', parent);
        var timepicker = parent.data('timepicker');
        if(typeof timepicker == 'undefined' || timepicker == ''){
            timepicker = false;
        }else{
            timepicker =true;
        }
        var options = {
            singleDatePicker: false,
            sameDate: true,
            sameDateMulti: true,
            autoApply: true,
            disabledPast: true,
            dateFormat: 'DD/MM/YYYY',
            customClass: '',
            widthSingle: 500,
            onlyShowCurrentMonth: true,
            timePicker: timepicker,
        };
        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        check_in_out.daterangepicker(options,
            function (start, end, label) {
                check_in_input.val(start.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-in-input').val(start.format('YYYY-MM-DD'));
                check_in_render.html(start.format(parent.data('format')));
                check_out_input.val(end.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-out-input').val(end.format('YYYY-MM-DD'));
                check_out_render.html(end.format(parent.data('format')));
                if(timepicker){
                    check_in_input.val(start.format(parent.data('date-format')));
                    $('.check-in-input-time', parent).val(start.format(parent.data('time-format')));
                    check_out_input.val(end.format(parent.data('date-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));
                }
                check_in_out.trigger('daterangepicker_change', [start, end]);
                if (window.matchMedia('(max-width: 767px)').matches) {
                    $('label', parent).hide();
                    $('.render', parent).show();
                    $('.check-in-wrapper span', parent).show();
                }
            });
        date_wrapper.click(function (e) {
            check_in_out.trigger('click');
        });
    });
    //form date in tour
    $('.form-date-search-new', body).each(function () {
        var parent = $(this),
            date_wrapper = $('.date-wrapper', parent),
            check_in_input = $('.check-in-input', parent),
            check_out_input = $('.check-out-input', parent),
            check_in_out = $('.check-in-out', parent),
            check_in_render = $('.check-in-render', parent),
            check_out_render = $('.check-out-render', parent);
        var timepicker = parent.data('timepicker');
        if(typeof timepicker == 'undefined' || timepicker == ''){
            timepicker = false;
        }else{
            timepicker =true;
        }
        var options = {
            singleDatePicker: false,
            autoApply: true,
            disabledPast: true,
            dateFormat: 'DD/MM/YYYY',
            customClass: '',
            widthSingle: 500,
            onlyShowCurrentMonth: true,
            timePicker: timepicker,
        };
        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        check_in_out.daterangepicker(options,
            function (start, end, label) {
                check_in_input.val(start.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-in-input').val(start.format('YYYY-MM-DD'));
                var html = start.format(parent.data('format')) + ' - ' ;
                check_in_render.html(html);
                check_out_input.val(end.format(parent.data('format')));
                $('#tp_hotel .form-date-search .check-out-input').val(end.format('YYYY-MM-DD'));
                check_out_render.html(end.format(parent.data('format')));

                if(timepicker){
                    check_in_input.val(start.format(parent.data('date-format')));
                    $('.check-in-input-time', parent).val(start.format(parent.data('time-format')));
                    check_out_input.val(end.format(parent.data('date-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));
                    $('.check-out-input-time', parent).val(end.format(parent.data('time-format')));


                }
                check_in_out.trigger('daterangepicker_change', [start, end]);
                if (window.matchMedia('(max-width: 767px)').matches) {
                    $('label', parent).hide();
                    $('.render', parent).show();
                    $('.check-in-wrapper span', parent).show();
                }
            });
        date_wrapper.click(function (e) {
            check_in_out.trigger('click');
        });
    });
    $('.form-date-hotel-room', body).each(function () {
        var parent = $(this),
            date_wrapper = $('.date-wrapper', parent),
            check_in_input = $('.check-in-input', parent),
            check_out_input = $('.check-out-input', parent),
            check_in_out = $('.check-in-out', parent),
            check_in_render = $('.check-in-render', parent),
            check_out_render = $('.check-out-render', parent),
            availabilityDate = $(this).data('availability-date');
        var minimum = check_in_out.data('minimum-day');
        if (typeof minimum !== 'number') {
            minimum = 0;
        }
        var options = {
            singleDatePicker: false,
            autoApply: true,
            disabledPast: true,
            dateFormat: 'DD/MM/YYYY',
            widthSingle: 500,
            onlyShowCurrentMonth: true,
            minimumCheckin: minimum,
            classNotAvailable: ['disabled', 'off'],
            enableLoading: true,
            showEventTooltip: true,
            fetchEvents: function (start, end, el, callback) {
                var events = [];
                if (el.flag_get_events) {
                    return false;
                }
                el.flag_get_events = true;
                el.container.find('.loader-wrapper').show();
                var data = {
                    action: check_in_out.data('action'),
                    start: start.format('YYYY-MM-DD'),
                    end: end.format('YYYY-MM-DD'),
                    post_id: check_in_out.data('room-id'),
                    security: st_params._s
                };
                $.post(st_params.ajax_url, data, function (respon) {
                    if (typeof respon === 'object') {
                        if (typeof respon.events === 'object') {
                            events = respon.events;
                        } else {
                            events = respon;
                        }
                    } else {
                        console.log('Can not get data');
                    }
                    callback(events, el);
                    el.flag_get_events = false;
                    el.container.find('.loader-wrapper').hide();
                }, 'json');
            }
        };

        if(typeof availabilityDate != 'undefined'){
            options['minDate'] = availabilityDate;
        }

        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        check_in_out.daterangepicker(options,
            function (start, end, label) {
                check_in_input.val(start.format(parent.data('format')));
                check_in_render.html(start.format(parent.data('format')));
                check_out_input.val(end.format(parent.data('format')));
                check_out_render.html(end.format(parent.data('format')));
            });
        date_wrapper.click(function (e) {
            check_in_out.trigger('click');
        });
    });

    $('.form-extra-field').each(function () {
        var parent = $(this);
        $('.dropdown', parent).click(function (e) {
            var dropdown_menu = $('[aria-labelledby="' +$(this).attr('id') + '"]', parent);
            $('.form-extra-field').find('.dropdown-menu').not(dropdown_menu).slideUp(50);
            dropdown_menu.slideToggle(50);
            if ($('.ovscroll').length) {
                $('.ovscroll').getNiceScroll().resize();
            }
        });
        $('input[name="adult_number"]', parent).change(function () {
            var adults = parseInt($(this).val());
            var html = adults;
            if (typeof adults == 'number') {
                if (adults < 2) {
                    html = adults + ' ' + $('.render .adult', parent).data('text');
                } else {
                    html = adults + ' ' + $('.render .adult', parent).data('text-multi');
                }
            }
            $('.render .adult', parent).html(html);
        });
        $('input[name="adult_number"]', parent).trigger('change');
        $('input[name="child_number"]', parent).change(function () {
            var children = parseInt($(this).val());
            var html = children;
            if (typeof children == 'number') {
                if (children < 2) {
                    html = children + ' ' + $('.render .children', parent).data('text');
                } else {
                    html = children + ' ' + $('.render .children', parent).data('text-multi');
                }
            }
            $('.render .children', parent).html(html);
        });
        $('input[name="child_number"]', parent).trigger('change');
    });
    //form guest in tour
    $('.form-extra-field.field-guest-new').each(function () {
        var parent = $(this);

        $('input[name="adult_number"]', parent).change(function () {
            var adults = parseInt($(this).val());
            var html = adults;
            if (typeof adults == 'number') {
                if (adults < 2) {
                    html = adults + ' ' + $('.render .adult', parent).data('text');
                } else {
                    html = adults + ' ' + $('.render .adult', parent).data('text-multi');
                }
            }
            $('.render .adult', parent).html(html);
            $('.render', parent).removeClass('hide');
            parent.find('label').first().hide();
        });
        //$('input[name="adult_number"]', parent).trigger('change');
        $('input[name="child_number"]', parent).change(function () {
            var children = parseInt($(this).val());
            var html = children;
            if (typeof children == 'number') {
                if (children < 2) {
                    html = children + ' ' + $('.render .children', parent).data('text');
                } else {
                    html = children + ' ' + $('.render .children', parent).data('text-multi');
                }
            }
            $('.render .children', parent).html(html);
            $('.render', parent).removeClass('hide');
            parent.find('label').first().hide();
        });
       // $('input[name="child_number"]', parent).trigger('change');
    });
    body.click(function (ev) {
        if ($(ev.target).closest('.form-extra-field').length == 0) {
            $('.form-extra-field .dropdown-menu').slideUp(50);
            $('.form-extra-field .arrow').removeClass('fa-angle-up').addClass('fa-angle-down');
        }
    });
    $('.form-more-extra', body).each(function () {
        var t = $(this),
            parent = t.closest('.form-more-extra');
        $('.dropdown', parent).click(function (ev) {
            ev.preventDefault();
            $('.extras', parent).slideToggle(200);
            $('.arrow', parent).toggleClass('fa-caret-up fa-caret-down');
        });
    });
    $('a[data-toggle="tab"][href="#map-tab"]').on('click', function (e) {
        e.preventDefault();
        loadMap('.st-map');
    });

    function loadMap(el) {
        $(el, body).each(function () {
            var parent = $(this),
                mapEl = $('.google-map', parent);
            var style = mapEl.data('style');
            var data = {
                center: {
                    lat: parseFloat(mapEl.data().lat),
                    lng: parseFloat(mapEl.data().lng)
                },
                zoom: mapEl.data().zoom,
                disableDefaultUI: mapEl.data().disablecontrol,
                styles: mapStyles[style] ? mapStyles[style] : ''
            };
            var showcustomcontrol = mapEl.data('showcustomcontrol');

            if (typeof (new google.maps.Map(mapEl.get(0), data)) === "undefined") {
                var map = new google.maps.Map(mapEl.get(0), data);
                new google.maps.Marker({
                    position: new google.maps.LatLng(mapEl.data().lat, mapEl.data().lng),
                    icon: mapEl.data().icon,
                    map: map,
                });
                if (showcustomcontrol) {
                    customControlGoogleMap(mapEl, map);
                }
            }
        });
    }
    $('.st-map', body).each(function () {
        var parent = $(this),
            mapEl = $('.google-map', parent),
            mapData = mapEl.data('data_show'),
            lat_center = mapEl.data('lat'),
            lng_center = mapEl.data('lng'),
            data_zoom = mapEl.data('zoom'),
            mapIcon = mapEl.data('icon');
            console.log(lat_center);
            console.log(lng_center);

            initMapDetail(mapEl, mapData, lat_center, lng_center,data_zoom, mapIcon);
            
    });


    /*Destination selection*/
    $('.field-detination').each(function () {
        var parent = $(this);
        var dropdown_menu = $('.dropdown-menu', parent);
        $('li', dropdown_menu).on('click', function () {
            var target = $(this).closest('ul.dropdown-menu').attr('aria-labelledby');
            var focus = parent.find('#' + target);
            $('.destination', focus).text($(this).find('span').text());
            $('input[name="location_name"]', focus).val($(this).find('span').text());
            $('input.location_name', focus).val($(this).find('span').text());
            $('input[name="location_id"]', focus).val($(this).data('value'));
            $('input.location_id', focus).val($(this).data('value'));
            if (window.matchMedia('(max-width: 767px)').matches) {
                $('label', focus).hide();
                $('.render', focus).show();
            }
            dropdown_menu.slideUp(50);
        });
    });
    /* nicescroll */
    $('.ovscroll').each(function () {
        $(this).niceScroll();
    });
    $('.map-view-popup .col-left-map').each(function () {
        $(this).niceScroll();
    });
    /*Filter mobile click*/
    $('.toolbar-action-mobile .btn-from-to').on('click', function (e) {
        e.preventDefault();
        window.scrollTo({
            top: '46',
        });
        $('.sidebar-filter').fadeIn();
        $('.top-filter').fadeIn();
        $('.sidebar-filter .sidebar-search-form').show();
        $('.sidebar-filter .sidebar-item-wrapper').hide();
        $('.sidebar-filter .form-date-search').hide();
        $('html, body').css({overflow: 'hidden'});
    });
    $('.toolbar-action-mobile .btn-filter').on('click', function (e) {
        e.preventDefault();
        window.scrollTo({
            top: '46',
        });
        $('.sidebar-filter').fadeIn();
        $('.top-filter').fadeIn();
        $('.sidebar-filter .sidebar-item-wrapper').fadeIn();
        $('.sidebar-filter .sidebar-search-form').hide();
        $('html, body').css({overflow: 'hidden'});
    });
    $('.toolbar-action-mobile .btn-sort').on('click', function (e) {
        e.preventDefault();
        $('.sort-menu-mobile').fadeIn();
    });
    $('.toolbar-action-mobile .btn-map').on('click', function (e) {
        e.preventDefault();
        window.scrollTo({
            top: '46',
        });
        $('.page-half-map .col-right').show();
        $('.full-map .full-map-item').show();
        $('html, body').css({overflow: 'hidden'});
    });
    $('.sidebar-filter .close-filter').on('click', function () {
        $(this).closest('.sidebar-filter').fadeOut(function () {
            $('html, body').css({overflow: 'auto'});
        });
    });
    $('.top-filter .close-filter').on('click', function () {
        $(this).closest('.top-filter').fadeOut(function () {
            $('html, body').css({overflow: 'auto'});
        });
    });
    $('.sort-menu-mobile .close-filter').on('click', function () {
        $(this).closest('.sort-menu-mobile').fadeOut();
    });
    $('.page-half-map .close-half-map').on('click', function () {
        $(this).closest('.col-right').hide();
        $('html, body').css({overflow: 'auto'});
        if ($('#btn-show-map-mobile').length) {
            $('#btn-show-map-mobile').prop('checked', false);
        }
    });
    $('.full-map .close-map').on('click', function () {
        $(this).closest('.full-map').hide();
        $('html, body').css({overflow: 'auto'});
    });
    $(window).resize(function () {
        if (window.matchMedia('(min-width: 768px)').matches) {
            if ($('.full-map-item').length) {
                if (!$('.full-map-item').is(':visible')) {
                    $('.full-map-item').attr('style', '');
                }
            }
            if ($('.st-hotel-result .sidebar-filter').length) {
                if (!$('.st-hotel-result .sidebar-filter').is(':visible')) {
                    $('.st-hotel-result .sidebar-filter').attr('style', '');
                }
            }
            if ($('.st-hotel-result .top-filter').length) {
                if (!$('.st-hotel-result .top-filter').is(':visible')) {
                    $('.st-hotel-result .top-filter').attr('style', '');
                }
            }
        }
        if (window.matchMedia('(min-width: 992px)').matches) {
            if ($('.page-half-map .col-right').length) {
                if (!$('.page-half-map .col-right').is(':visible') && $('#btn-show-map').is(':checked')) {
                    $('.page-half-map .col-right').attr('style', '');
                }
            }
        }
        if (window.matchMedia('(max-width: 991px)').matches) {
            if ($('.page-half-map .col-right').length) {
                if ($('.page-half-map .col-right').is(':visible')) {
                    $('.page-half-map .col-right').attr('style', '');
                }
            }
            if ($('.page-half-map .col-left').length) {
                if ($('.page-half-map .col-left').is(':visible')) {
                    $('.page-half-map .col-left').getNiceScroll().remove();
                }
            }
        }
    });
    /* On/Off map */
    //Check scroll page
    /*$(document).ready(function () {
        if (window.matchMedia('(min-width: 991px)').matches) {
            var c  = 0;
            var c1 = 0;
            $(window).scroll(function (event) {
                if ($('#btn-show-map').is(':checked') && $('.page-half-map').length) {
                    var scroll = $(window).scrollTop();
                    var topEl  = $('.page-half-map').offset().top;
                    var colLeft = $('.page-half-map .col-left').height();
                    var divResult = $('#modern-search-result').height();
                    if (scroll >= topEl - 1 && scroll != 0) {
                        if (c == 0) {
                            if(divResult >= colLeft) {
                                /!*window.scrollTo({
                                    top: topEl,
                                    behavior: 'auto'
                                });*!/
                                $('.page-half-map').addClass('static').find('.col-left').niceScroll();
                            }
                        }
                    } else {
                        $('.page-half-map').removeClass('static');
                        if (c != 2) {
                            c = 0;
                            $('.page-half-map').find('.col-left').getNiceScroll().remove();
                        } else {
                            if (c1 == 0) {
                                if (scroll < topEl - 100) {
                                    c = 0;
                                    $('.page-half-map').find('.col-left').animate({scrollTop: 0});
                                    c1 = 1;
                                }
                            }
                        }
                    }
                }
            });
            $('.page-half-map .col-left').scroll(function (event) {
                if ($('#btn-show-map').is(':checked')) {
                    var t = $(this);
                    if (t.scrollTop() <= 1) {
                        c = 0;
                        if (c == 0) {
                            $('.page-half-map').removeClass('static').find('.col-left').getNiceScroll().remove();
                        }
                    } else if (typeof t.getNiceScroll()[0] != 'undefined') {
                        if (t.getNiceScroll()[0].page.maxh <= t.scrollTop()) {
                            $('.page-half-map').removeClass('static').find('.col-left').getNiceScroll().remove();
                            c  = 2;
                            c1 = 0;
                        }
                    }
                }
            });
        }
    });*/
    if ($('.payment-form .payment-item').length) {
        $('.payment-form .payment-item').eq(0).find('.st-icheck-item input[type="radio"]').prop('checked', true);
        $('.payment-form .payment-item').eq(0).find('.dropdown-menu').slideDown();
    }
    $('.payment-form .payment-item').each(function (l, i) {
        var parent = $(this);
        $('.st-icheck-item input[type="radio"]', parent).change(function () {
            $('.payment-form .payment-item .dropdown-menu').slideUp();
            if ($(this).is(':checked')) {
                if ($('.dropdown-menu', parent).length) {
                    $('.dropdown-menu', parent).slideDown();
                }
            }
        });
    });
    $('.info-section .detail button').on('click', function () {
        var parent = $(this).closest('.detail');
        $('.detail-list', parent).slideToggle();
    });
    /*$('#st-login-form form').submit(function (ev) {
        ev.preventDefault();
        var form    = $(this),
            loader  = form.closest('.modal-content').find('.loader-wrapper'),
            message = $('.message-wrapper', form);
        var data    = form.serializeArray();
        data.push({
            name : 'security',
            value: st_params._s
        });
        message.html('');
        loader.show();
        $.post(st_params.ajax_url, data, function (respon) {
            if (typeof respon == 'object') {
                message.html(respon.message);
                if (respon.status == 1) {
                    setTimeout(function () {
                        window.location.href = respon.redirect;
                    }, 2000);
                }
            }
            loader.hide();
        }, 'json');
    });*/
    /* Taxonomy advance search */
    var advFacilities = [];
    $('.advance-item.facilities input[type="checkbox"]').each(function () {
        var t = $(this);
        if (t.is(':checked')) {
            advFacilities.push(t.val());
        }
    });
    $('.advance-item.facilities input[type="checkbox"]').change(function () {
        var t = $(this);
        if (t.is(':checked')) {
            advFacilities.push(t.val());
        } else {
            var index = advFacilities.indexOf(t.val());
            if (index > -1) {
                advFacilities.splice(index, 1);
            }
        }
        t.closest('.facilities').find('.data_taxonomy').val(advFacilities.join(','));
    });
    $('#st-login-form form', body).submit(function (ev) {
        ev.preventDefault();
        var form = $(this),
            loader = form.closest('.modal-content').find('.loader-wrapper'),
            message = $('.message-wrapper', form);
        var data = form.serializeArray();
        data.push({
            name: 'security',
            value: st_params._s
        });
        message.html('');
        loader.show();
        $.post(st_params.ajax_url, data, function (respon) {
            if (typeof respon == 'object') {
                message.html(respon.message);
                setTimeout(function () {
                    message.html('');
                }, 2000);
                if (respon.status == 1) {
                    setTimeout(function () {
                        window.location.href = respon.redirect;
                    }, 2000);
                }
            }
            loader.hide();
        }, 'json');
    });
    $('#st-register-form form', body).submit(function (ev) {
        ev.preventDefault();
        var form = $(this),
            loader = form.closest('.modal-content').find('.loader-wrapper'),
            message = $('.message-wrapper', form);
        var data = form.serializeArray();
        data.push({
            name: 'security',
            value: st_params._s
        });
        message.html('');
        loader.show();
        $.post(st_params.ajax_url, data, function (respon) {
            loader.hide();
            if (typeof respon == 'object') {
                message.html(respon.message);
                if (respon.status == 1) {
                    swal({
                        type: 'success',
                        title: respon.message,
                        text: respon.sub_message,
                        showConfirmButton: true,
                        confirmButtonText: respon.closeText,
                        onClose: function () {
                            $('#st-login-form', body).modal('show');
                            $('#st-register-form', body).modal('hide');
                        },
                        allowOutsideClick: false
                    });
                } else {
                    message.html(respon.message);
                    setTimeout(function () {
                        message.html('');
                    }, 2000);
                }
            }
        }, 'json');
    });
    $('#st-forgot-form form', body).submit(function (ev) {
        ev.preventDefault();
        var form = $(this),
            loader = form.closest('.modal-content').find('.loader-wrapper'),
            message = $('.message-wrapper', form);
        var data = form.serializeArray();
        data.push({
            name: 'security',
            value: st_params._s
        });
        message.html('');
        loader.show();
        $.post(st_params.ajax_url, data, function (respon) {
            if (typeof respon == 'object') {
                message.html(respon.message);
                setTimeout(function () {
                    message.html('');
                }, 2000);
            }
            loader.hide();
        }, 'json');
    });
    $('.select2-languages', body).select2({
        minimumResultsForSearch: -1
    });
    $('.select2-languages').change(function () {
        var target = $('option:selected', this).data('target');
        if (target) {
            window.location.href = target;
        }
    });
    $('.select2-currencies', body).select2({
        minimumResultsForSearch: -1
    });
    $('.select2-currencies').change(function () {
        var target = $('option:selected', this).data('target');
        if (target) {
            window.location.href = target;
        }
    });
    $('.form-check-availability-hotel', body).submit(function (ev) {
        ev.preventDefault();
        var form = $(this),
            parent = form.parent(),
            loader = $('.loader-wrapper', parent),
            message = $('.message-wrapper', form);
        var has_fixed = form.closest('.fixed-on-mobile');
        if (has_fixed.hasClass('open')) {
            has_fixed.removeClass('open').hide();
        }
        var data = form.serializeArray();
        data.push({
            name: 'security',
            value: st_params._s
        });
        message.html('');
        loader.show();
        $('.st-list-rooms .loader-wrapper').show();
        $.post(st_params.ajax_url, data, function (respon) {
            if (typeof respon == 'object') {
                if (respon.message) {
                    message.html(respon.message);
                }
                $('.st-list-rooms .fetch').html(respon.html);
                $('html, body').animate({
                    scrollTop: $('.st-list-rooms', body).offset().top - 150
                }, 500);
                $('[data-toggle="tooltip"]').tooltip();
            }
            $('.st-list-rooms .loader-wrapper').hide();
            loader.hide();
        }, 'json');
    });
    body.on('click', '.btn-show-price', function (ev) {
        ev.preventDefault();
        $('.form-check-availability-hotel', body).trigger('submit');
    });
    $('.shares .social-share').click(function (ev) {
        ev.preventDefault();
        $('.shares .share-wrapper').slideToggle(200);
    });
    $(document).on('click', '.btn_add_wishlist', function (event) {
        event.preventDefault();
        var $this = $(this);
        $.ajax({
            url: st_params.ajax_url,
            type: "POST",
            data: {action: "st_add_wishlist", data_id: $(this).data('id'), data_type: $(this).data('type')},
            dataType: "json",
        }).done(function (html) {
            $this.html(html.icon).attr("data-original-title", html.title)
        })
    });
    $('.st-like-review').click(function (e) {
        e.preventDefault();
        var me = $(this);
        var comment_id = me.data('id');
        $.ajax({
            url: st_params.ajax_url,
            type: 'post',
            dataType: 'json',
            data: {
                action: 'like_review',
                comment_ID: comment_id
            },
            success: function (res) {
                if (res.status) {
                    $('i', me).toggleClass('fa-thumbs-o-up fa-thumbs-o-down');
                    if ($('.booking-item-review-rate').length) {
                        $(me).toggleClass('fa-thumbs-o-up fa-thumbs-o-down');
                    }
                    if (typeof res.data.like_count != undefined) {
                        res.data.like_count = parseInt(res.data.like_count);
                        me.parent().find('span').html(res.data.like_count);
                    }
                }
            }
        });
    });
    $('.review-form .review-items .rates .fa').each(function () {
        var list = $(this).parent(),
            listItems = list.children(),
            itemIndex = $(this).index(),
            parentItem = list.parent();
        $(this).hover(function () {
            for (var i = 0; i < listItems.length; i++) {
                if (i <= itemIndex) {
                    $(listItems[i]).addClass('hovered');
                } else {
                    break;
                }
            }
            $(this).click(function () {
                for (var i = 0; i < listItems.length; i++) {
                    if (i <= itemIndex) {
                        $(listItems[i]).addClass('selected');
                    } else {
                        $(listItems[i]).removeClass('selected');
                    }
                }
                ;
                parentItem.children('.st_review_stats').val(itemIndex + 1);
            });
        }, function () {
            listItems.removeClass('hovered');
        });
    });
    $('.review-form .st-stars .fa').each(function () {
        var list = $(this).parent(),
            listItems = list.children(),
            itemIndex = $(this).index(),
            parentItem = list.parent();
        $(this).hover(function () {
            for (var i = 0; i < listItems.length; i++) {
                if (i <= itemIndex) {
                    $(listItems[i]).addClass('hovered');
                } else {
                    break;
                }
            }
            $(this).click(function () {
                for (var i = 0; i < listItems.length; i++) {
                    if (i <= itemIndex) {
                        $(listItems[i]).addClass('selected');
                    } else {
                        $(listItems[i]).removeClass('selected');
                    }
                }
                parentItem.children('.st_review_stats').val(itemIndex + 1);
            });
        }, function () {
            listItems.removeClass('hovered');
        });
    });
    /* Mobile location */
    $('.search-form-mobile .dropdown-menu li').click(function () {
        var t = $(this);
        var parent = t.closest('.dropdown');
        $('input[name="location_id"]', parent).val(t.data('value'));
        $('input[name="location_name"]', parent).val(t.find('span').text());
    });
    $(document).on('click', '.service-add-wishlist.login', function (event) {
        event.preventDefault();
        var t = $(this);
        t.addClass('loading');
        $.ajax({
            url: st_params.ajax_url,
            type: "POST",
            data: {action: "st_add_wishlist", data_id: t.data('id'), data_type: t.data('type')},
            dataType: "json",
        }).done(function (html) {
            if (html.status == 'true') {
                if (html.added == 'true') {
                    t.addClass('added');
                } else {
                    t.removeClass('added');
                }
                t.attr('title', html.title);
            }
            t.removeClass('loading');
        })
    });
    if ($('#contact-map-new').length) {
        initMapContactPage($('#contact-map-new'));
    }
    $('.field-detination .dropdown-menu').each(function () {
        $(this).niceScroll({
            cursorcolor: "#a0a9b2",
        });
    });
    $(document).ready(function () {
        // Tour Package Popup
        if ($('.st-form-package').length) {
            $('.st-form-package').magnificPopup({
                removalDelay  : 500,
                closeBtnInside: true,
                callbacks     : {
                    beforeOpen: function () {
                        this.st.mainClass = this.st.el.attr('data-effect');
                    }
                },
                midClick      : true,
                closeMarkup: '<button title="Close (Esc)" type="button" class="mfp-close"></button>',
            });
        }
        if (window.matchMedia('(max-width: 768px)').matches) {
            $('.as').slideDown();
        }
        if (window.matchMedia('(min-width: 991px)').matches) {
            var c = 0;
            var c1 = 0;
            $(window).scroll(function (event) {
                if ($('#btn-show-map').is(':checked') && $('.page-half-map').length) {
                    var scroll = $(window).scrollTop();
                    var topEl = $('.st-hotel-result').offset().top;
                    var colLeft = $('.page-half-map .col-left').height();
                    var divResult = $('#modern-search-result').height();
                    if (scroll >= topEl) {
                        if (divResult >= colLeft) {
                            if (c == 0) {
                                if ($("body").hasClass('rtl')) {
                                    $('.page-half-map').find('.col-left').niceScroll({railalign: 'left'});
                                } else {
                                    $('.page-half-map').find('.col-left').niceScroll();
                                }
                                c = 1;
                                $('.as').slideUp();
                            }
                        } else {
                            $('.page-half-map').find('.col-left').getNiceScroll().remove();
                            $('.as').slideDown(50);
                        }
                    } else {
                        $('.as').slideUp();
                        if (c == 1) {
                            $('.page-half-map').find('.col-left').animate({scrollTop: 0}).getNiceScroll().remove();
                            c = 0;
                        }
                    }
                }
            });
            $('.page-half-map .col-left').scroll(function (event) {
                var scroll = $(window).scrollTop();
                var topEl = $('.st-hotel-result').offset().top;
                if ($('#btn-show-map').is(':checked')) {
                    var t = $(this);
                    if (t.scrollTop() <= 0) {
                        if (c == 1) {
                            $('.page-half-map').find('.col-left').getNiceScroll().remove();
                            window.scrollTo({
                                top: topEl - 1,
                            });
                            c = 0;
                        }
                    } else if (typeof t.getNiceScroll()[0] != 'undefined') {
                        if (t.getNiceScroll()[0].page.maxh <= t.scrollTop()) {
                            $('.page-half-map').find('.col-left').getNiceScroll().remove();
                            $('.as').slideDown('slow');
                            c = 1;
                        }
                    }
                }
            });
        }
    });
    $('.coupon-section form .btn').click(function (e) {
        e.preventDefault();
        var sform = $(this).closest('form');
        if ($('#field-coupon_code', sform).val() === '') {
            $('#field-coupon_code', sform).addClass('error');
        } else {
            $('#field-coupon_code', sform).removeClass('error');
            $(this).append('<i class="fa fa-spinner fa-spin"></i>');
            var data = {
                'action': 'apply_mdcoupon_function',
                'code': $('#field-coupon_code', sform).val()
            };
            $.post(st_params.ajax_url, data, function (respon, textStatus, xhr) {
                if (respon.status == 1) {
                    sform.submit();
                }
            }, 'json');
        }
    });
    $('.sidebar-widget h4:first-child').each(function () {
        $(this).wrap("<div class='sidebar-title'></div>");
    });
    if ($('#sticky-nav').length && window.matchMedia('(min-width: 991px)').matches) {
        var topElSearch = $('#sticky-nav').offset().top;
        var searchFormHeight = $('#sticky-nav').closest('.search-form-wrapper').outerHeight();
        $(window).resize(function () {
            var topElSearch = $('#sticky-nav').offset().top;
            var searchFormHeight = $('#sticky-nav').closest('.search-form-wrapper').outerHeight();
        });
        $(window).scroll(function (event) {
            var scroll = $(window).scrollTop();
            var top = 0;
            if ($('#wpadminbar').length) {
                top = $('#wpadminbar').height();
            }
            if (scroll > topElSearch - top) {
                $('#sticky-nav').closest('.search-form-wrapper').css({height: searchFormHeight + 'px'});
                $('#sticky-nav').find('form').addClass('container');
                $('#sticky-nav').css({top: top + 'px', 'margin-top': '0px'});
                $('#sticky-nav').addClass('sticky');
                $('#sticky-nav .dropdown-menu').getNiceScroll().resize();
                $('#sticky-nav').addClass('small');
            } else {
                $('#sticky-nav').closest('.search-form-wrapper').css({height: 'auto'});
                $('#sticky-nav').find('form').removeClass('container');
                $('#sticky-nav').css({top: 'auto', 'margin-top': '50px'});
                $('#sticky-nav').removeClass('sticky');
                $('#sticky-nav .dropdown-menu').getNiceScroll().resize();
                $('#sticky-nav').removeClass('small');
            }
        })
    }
    $('.st-number-wrapper').each(function () {
        var timeOut = 0;
        var t = $(this);
        var input = t.find('.st-input-number');
        input.after('<span class="prev"><svg width="18px" height="2px" viewBox="0 0 18 2" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n' +
            '    <!-- Generator: Sketch 49 (51002) - http://www.bohemiancoding.com/sketch -->\n' +
            '    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">\n' +
            '        <g id="Tour_Detail_1" transform="translate(-1180.000000, -1085.000000)" stroke="#5E6D77" stroke-width="1.5">\n' +
            '            <g id="check-avai" transform="translate(1034.000000, 867.000000)">\n' +
            '                <g id="adults" transform="translate(0.000000, 184.000000)">\n' +
            '                    <g id="ico_subtract" transform="translate(147.000000, 35.000000)">\n' +
            '                        <path d="M0.5,0.038 L15.5,0.038" id="Shape"></path>\n' +
            '                    </g>\n' +
            '                </g>\n' +
            '            </g>\n' +
            '        </g>\n' +
            '    </g>\n' +
            '</svg></span>');
        input.before('<span class="next"><svg width="18px" height="18px" viewBox="0 0 18 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n' +
            '    <!-- Generator: Sketch 49 (51002) - http://www.bohemiancoding.com/sketch -->\n' +
            '    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">\n' +
            '        <g id="Tour_Detail_1" transform="translate(-1258.000000, -1077.000000)" stroke="#5E6D77" stroke-width="1.5">\n' +
            '            <g id="check-avai" transform="translate(1034.000000, 867.000000)">\n' +
            '                <g id="adults" transform="translate(0.000000, 184.000000)">\n' +
            '                    <g id="ico_add" transform="translate(225.000000, 27.000000)">\n' +
            '                        <path d="M0.5,8 L15.5,8" id="Shape"></path>\n' +
            '                        <path d="M8,0.5 L8,15.5" id="Shape"></path>\n' +
            '                    </g>\n' +
            '                </g>\n' +
            '            </g>\n' +
            '        </g>\n' +
            '    </g>\n' +
            '</svg></span>');
        var min = input.data('min');
        var max = input.data('max');
        t.find('span').on("click", function () {
            var $button = $(this);
            numberButtonFunc($button);
        });
        t.find('span').on("mousedown touchstart", function () {
            var $button = $(this);
            timeOut = setInterval(function () {
                numberButtonFunc($button);
            }, 150);
        }).bind('mouseup mouseleave touchend', function () {
            clearInterval(timeOut);
        });
        function numberButtonFunc($button) {
            var oldValue = $button.parent().find("input").val();
            var container = $button.closest('.form-guest-search');
            var total = 0;
            $('input[type="text"]', container).each(function () {
                total += parseInt($(this).val());
            });
            var newVal = oldValue;
            if ($button.hasClass('next')) {
                if (total < max) {
                    if (oldValue < max) {
                        newVal = parseFloat(oldValue) + 1;
                    } else {
                        newVal = max;
                    }
                }
            } else {
                if (oldValue > min) {
                    newVal = parseFloat(oldValue) - 1;
                } else {
                    newVal = min;
                }
            }
            $button.parent().find("input").val(newVal).trigger('change');
            $('input[name="' + $button.parent().find("input").attr('name') + '"]', '.search-form').trigger('change');
            $('input[name="' + $button.parent().find("input").attr('name') + '"]', '.form-check-availability-hotel').trigger('change');
            $('input[name="' + $button.parent().find("input").attr('name') + '"]', '.single-room-form').trigger('change');
            if (window.matchMedia('(max-width: 767px)').matches) {
                $('#dropdown-1 label', $button.closest('.field-guest')).hide();
                $('#dropdown-1 .render', $button.closest('.field-guest')).show();
            }
        }
    });
    $('.btn-close-guest-form').on('click', function () {
        $('.field-guest  .dropdown-menu').slideUp(50);
    });
    $('.st-cut-text').each(function () {
        var t = $(this);
        if (t.text().length > 0) {
            var arr = t.text().trim().split(' ');
            console.log(arr);
        }
    });
    $('.booking-item-review-expand-more').on('click', function () {
        var t = $(this);
        t.closest('.booking-item-review-content').find('.booking-item-review-more').fadeIn();
        t.closest('.booking-item-review-content').find('.booking-item-review-expand-less').show();
        t.hide();
    });
    $('.booking-item-review-expand-less').on('click', function () {
        var t = $(this);
        t.closest('.booking-item-review-content').find('.booking-item-review-more').fadeOut();
        t.closest('.booking-item-review-content').find('.booking-item-review-expand-more').show();
        t.hide();
    });
    $(document).ready(function () {
        $('.st-service-slider').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 4,
                margin: 20,
                responsiveClass: true,
                dots: false,
                responsive: {
                    0: {
                        items: 2,
                        nav: false,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                        nav: true,
                    },
                    1200: {
                        items: 4,
                        nav: true,
                    }
                }
            });
        });

        $('.list-service-style2').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 3,
                margin: 20,
                responsiveClass: true,
                dots: true,
                responsive: {
                    0: {
                        items: 1,
                        nav: false,
                        margin: 15,
                    },
                    576:{
                        items: 2,
                        nav: false,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                        nav: true,
                    },
                    1200: {
                        items: 3,
                        nav: true,
                    }
                }
            });
        });
        $('.list-service-style3').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 3,
                margin: 30,
                responsiveClass: true,
                dots: true,
                responsive: {
                    0: {
                        items: 1,
                        nav: false,
                        margin: 15,
                    },
                    576:{
                        items: 2,
                        nav: false,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                        nav: true,
                    },
                    1200: {
                        items: 3,
                        nav: true,
                    }
                }
            });
        });
        $('.list-service-style4').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 3,
                margin: 30,
                responsiveClass: true,
                dots: true,
                nav: false,
                responsive: {
                    0: {
                        items: 1,
                        margin: 15,
                    },
                    576:{
                        items: 2,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                    },
                    1200: {
                        items: 3,
                    }
                }
            });
        });
        //Slider list of destination
        $('.list-destination-style8').each(function () {
            let t = $(this);
            var owl = $('.owl-carousel', t).owlCarousel({
                loop: true,
                margin: 30,
                items: 6,
                responsiveClass: true,
                dots: true,
                nav: true,
                responsive: {
                    0: {
                        items: 2,
                        nav: false,
                        margin: 15,
                    },
                    767: {
                        items: 4,
                        nav: true,
                    },
                    1200: {
                        items: 6,
                        nav: true,
                    }
                }
            });

        });

        $('.st-service-rental-slider').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 3,
                margin: 20,
                responsiveClass: true,
                dots: true,
                responsive: {
                    0: {
                        items: 2,
                        nav: false,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                        nav: true,
                    }
                }
            });
        });
        $('.st-testimonial-new .style-3').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 4,
                margin: 30,
                responsiveClass: true,
                dots: true,
                nav: true,
                responsive: {
                    0: {
                        items: 1,
                        margin: 15,
                    },
                    767: {
                        items: 1,
                        margin: 15,
                    },
                    992: {
                        items: 2,
                    },
                    1200: {
                        items: 2,
                    }
                }
            });
        });
        $('.st-testimonial-new .style-4').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 1,
                responsiveClass: true,
                dots: true,
                responsive: {
                    0: {
                        items: 1,

                    },
                    767: {
                        items: 1,

                    },
                    992: {
                        items: 1,
                    },
                    1200: {
                        items: 1,
                    }
                }
            });
        });
        $('.st-testimonial-slider').each(function () {
            $(this).owlCarousel({
                loop: false,
                items: 4,
                margin: 30,
                responsiveClass: true,
                dots: true,
                nav: false,
                responsive: {
                    0: {
                        items: 1,
                        margin: 15,
                    },
                    575: {
                        items: 2,
                        margin: 15,
                    },
                    992: {
                        items: 3,
                    },
                    1200: {
                        items: 3,
                    }
                }
            });
        });
        $('.owl-tour-program').each(function () {
            var parent = $(this).parent();
            var owl = $(this);
            owl.owlCarousel({
                loop: false,
                items: 3,
                margin: 20,
                responsiveClass: true,
                dots: false,
                nav: false,
                responsive: {
                    0: {
                        items: 1,
                        margin: 15,
                    },
                    992: {
                        items: 2,
                    },
                    1200: {
                        items: 3,
                    }
                }
            });
            $('.next', parent).click(function (ev) {
                ev.preventDefault();
                owl.trigger('next.owl.carousel');
            });
            $('.prev', parent).click(function (ev) {
                ev.preventDefault();
                owl.trigger('prev.owl.carousel');
            });
            owl.on('resized.owl.carousel', function () {
                setTimeout(function () {
                    if ($('.ovscroll').length) {
                        $('.ovscroll').getNiceScroll().resize();
                    }
                }, 1000);
            });
        });
        /* BG Slider */
        if ($('.search-form-wrapper.slider').length) {
            var heightSlider = $('.search-form-wrapper.slider').outerHeight();
            $('.st-bg-slider').fotorama({
                height: heightSlider
            });
        }
        $(window).resize(function () {
            if ($('.search-form-wrapper.slider').length) {
                var heightSlider = $('.search-form-wrapper.slider').outerHeight();
                $('.st-bg-slider').fotorama({
                    height: heightSlider
                });
            }
        });
    });
    var iex = 0;
    $('.st-program-list').each(function () {
        var t = $(this);
        $('.item .header', t).click(function () {
            $('.st-program .expand').text($('.st-program .expand').data('text-more'));
            iex = 0;
            $('.item', t).removeClass('active');
            $(this).parent().toggleClass('active');
        });
    });
    $('.st-program .expand').on('click', function () {
        var t = $(this);
        if (iex == 0) {
            $('.st-program .st-program-list .item').addClass('active');
            t.text(t.data('text-less'));
            iex = 1;
        } else {
            $('.st-program .st-program-list .item').removeClass('active');
            t.text(t.data('text-more'));
            iex = 0;
        }
    });
    $('.st-faq .item').each(function () {
        var t = $(this);
        t.find('.header').click(function () {
            $('.st-faq .item').not(t).removeClass('active');
            t.toggleClass('active');
        });
    });
    $(".st-video-popup").each(function () {
        $(this).magnificPopup({
            type: 'iframe'
        })
    });
    $('.st-gallery-popup').click(function (e) {
        e.preventDefault();
        var gallery = $(this).attr('href');
        $(gallery).magnificPopup({
            delegate: 'a',
            type: 'image',
            gallery: {
                enabled: true
            },
        }).magnificPopup('open');
    });
    //zzz
    $('.st-single-tour .form-date-search', body).each(function () {
        var parent = $(this),
            date_wrapper = $('.date-wrapper', parent),
            check_in_input = $('.check-in-input', parent),
            check_out_input = $('.check-out-input', parent),
            check_in_out_input = $('.check-in-out-input', parent),
            check_in_render = $('.check-in-render', parent),
            check_out_render = $('.check-out-render', parent),
            sts_checkout_label = $('.sts-tour-checkout-label', parent),
            availabilityDate = $(this).data('availability-date');

        var options = {
            singleDatePicker: true,
            showCalendar: false,
            sameDate: true,
            autoApply: true,
            disabledPast: true,
            dateFormat: 'DD/MM/YYYY',
            enableLoading: true,
            showEventTooltip: true,
            classNotAvailable: ['disabled', 'off'],
            disableHightLight: true,
            fetchEvents: function (start, end, el, callback) {
                var events = [];
                if (el.flag_get_events) {
                    return false;
                }
                el.flag_get_events = true;
                el.container.find('.loader-wrapper').show();
                var data = {
                    action: check_in_out_input.data('action'),
                    start: start.format('YYYY-MM-DD'),
                    end: end.format('YYYY-MM-DD'),
                    //tour_id: check_in_out_input.data('tour-id'),
                    security: st_params._s
                };
                var postType = check_in_out_input.data('posttype');
                if(typeof postType !== 'undefined' && postType === 'st_activity'){
                    data['activity_id'] = check_in_out_input.data('tour-id');
                }else{
                    data['tour_id'] = check_in_out_input.data('tour-id');
                }

                $.post(st_params.ajax_url, data, function (respon) {
                    if (typeof respon === 'object') {
                        if (typeof respon.events === 'object') {
                            events = respon.events;
                        }
                        else {
                            events = respon;
                        }
                    } else {
                        console.log('Can not get data');
                    }
                    callback(events, el);
                    el.flag_get_events = false;
                    el.container.find('.loader-wrapper').hide();
                }, 'json');
            }
        };

        if(typeof availabilityDate != 'undefined'){
            options['minDate'] = availabilityDate;
        }

        if (typeof locale_daterangepicker == 'object') {
            options.locale = locale_daterangepicker;
        }
        check_in_out_input.daterangepicker(options,
            function (start, end, label, elmDate) {
                check_in_input.val(start.format(parent.data('format')));
                check_out_input.val(end.format(parent.data('format')));
                check_in_render.html(start.format(parent.data('format')));
                check_out_render.html(end.format(parent.data('format')));
                if (start.format(parent.data('format')).toString() == end.format(parent.data('format')).toString()) {
                    sts_checkout_label.hide();
                } else {
                    sts_checkout_label.show();
                }
                if (typeof elmDate !== 'undefined' && elmDate !== false) {
                    if ($('.st-single-tour').length > 0) {
                        if (elmDate.target.classList.contains('has_starttime')) {
                            ajaxSelectStartTime(check_in_out_input.data('tour-id'), start.format(parent.data('format')), end.format(parent.data('format')), '', check_in_out_input.data('posttype'));
                        } else {
                            $('#starttime_tour option').remove();
                            $('#starttime_box').parent().hide();
                        }
                    }
                }
            });
        date_wrapper.click(function (e) {
            check_in_out_input.trigger('click');
        });
    });
    if ($('.logo').length) {
        var logoWidth = $('.logo').width();
        if ($('.has-mega-menu .mega-menu').length) {
            var stMegaWidth = $('.has-mega-menu .mega-menu .st-mega').first().outerWidth();
            $('.has-mega-menu .mega-menu').css({
                left: (logoWidth + 60) + 'px',
                width: stMegaWidth + 'px'
            });
            $('.has-mega-menu .mega-menu .st-mega').css({
                width: '100%'
            });
            $(window).resize(function () {
                var winDowsWidth = $('#header').width();
                if (winDowsWidth < (stMegaWidth + logoWidth + 130)) {
                    var megaWidth = winDowsWidth - (logoWidth + 130);
                    $('.has-mega-menu .mega-menu').css({
                        width: megaWidth + 'px',
                    });
                } else {
                    $('.has-mega-menu .mega-menu').css({
                        width: stMegaWidth + 'px',
                    });
                }
                if (window.matchMedia("(min-width: 992px)").matches) {
                    $('.has-mega-menu .mega-menu').show();
                } else {
                    $('.has-mega-menu .mega-menu').hide();
                }
            });
        }
    }
    var checkExWoo = 0;
    $('.booking-item-review-expand-new').on('click', function (e) {
        e.preventDefault();
        var t = $(this);
        var textMore = t.data('more');
        var textLess = t.data('hide');
        if (t.hasClass('collapsed')) {
            t.html(textLess);
        } else {
            if (checkExWoo == 0) {
                t.html(textLess);
                checkExWoo++;
            } else {
                t.html(textMore);
            }
        }
        t.closest('.booking-item-review-content').find('.booking-item-review-more').slideToggle();
    });
    if (typeof $('.player').YTPlayer === 'function') {
        $('.btn-play-video').click(function (e) {
            e.preventDefault();
            if (typeof player == 'undefined') {
                var player = jQuery(".player").YTPlayer({align: "center,center"});
            }
            var t = $(this);
            if (t.hasClass('play')) {
                player.playYTP();
                t.removeClass('play')
            } else {
                player.pauseYTP();
                t.addClass('play')
            }
        });
    }
    if ($('#starttime_hidden_load_form').length > 0) {
        $('#starttime_box').each(function () {
            var meS = $(this);
            var st_data_tour_id = $('#starttime_hidden_load_form').data('tourid');
            var st_data_starttime = $('#starttime_hidden_load_form').data('starttime');
            var st_data_checkin = $('#starttime_hidden_load_form').data('checkin');
            var st_data_checkout = $('#starttime_hidden_load_form').data('checkout');
            var st_posttype = $('#starttime_hidden_load_form').data('posttype');
            if (st_data_starttime != "" && typeof st_data_starttime !== 'undefined') {
                ajaxSelectStartTime(st_data_tour_id, st_data_checkin, st_data_checkout, st_data_starttime, st_posttype);
            }
        });
    }
    function ajaxSelectStartTime(tour_id, check_in, check_out, select_starttime, posttype = 'st_tours') {
        var sparent = $('.fixed-on-mobile');
        var overlay = $('.loader-wrapper', sparent);
        var data = {
            check_in: check_in,
            check_out: check_out
        };
        if (posttype === 'st_activity') {
            data['action'] = 'st_get_starttime_activity_frontend';
            data['activity_id'] = tour_id;
        } else {
            data['action'] = 'st_get_starttime_tour_frontend';
            data['tour_id'] = tour_id;
        }
        overlay.hide();
        $.ajax({
            url: st_params.ajax_url,
            dataType: 'json',
            type: 'post',
            data: data,
            beforeSend: function () {
                overlay.show();
            },
            success: function (doc) {
                var i = 0;
                if (doc['data'] != null && doc['data'].length > 0) {
                    $('#starttime_tour option').remove();
                    $('#starttime_box').parent().show();
                    var te = '';
                    for (i = 0; i < doc['data'].length; i++) {
                        var op_disable = '';
                        if (doc['check'][i] == '-1') {
                            if (doc['data'][i] == select_starttime) {
                                te += '<option value="' + doc['data'][i] + '" selected ' + op_disable + '>' + doc['data'][i] + '</option>';
                            } else {
                                te += '<option value="' + doc['data'][i] + '" ' + op_disable + '>' + doc['data'][i] + '</option>';
                            }
                        } else {
                            if (doc['check'][i] == '0') {
                                //op_disable = 'disabled="disabled"';
                                if (doc['data'][i] == select_starttime) {
                                    te += '<option value="' + doc['data'][i] + '" selected ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.no_vacancy + ' )' + '</option>';
                                } else {
                                    te += '<option value="' + doc['data'][i] + '" ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.no_vacancy + ' )' + '</option>';
                                }
                            } else {
                                if (doc['data'][i] == select_starttime) {
                                    if (doc['check'][i] == '1') {
                                        te += '<option value="' + doc['data'][i] + '" selected ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.a_vacancy + ' )' + '</option>';
                                    } else {
                                        if (doc['check'][i] < 0) {
                                            te += '<option value="' + doc['data'][i] + '" selected ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.no_vacancy + ' )' + '</option>';
                                        } else {
                                            te += '<option value="' + doc['data'][i] + '" selected ' + op_disable + '>' + doc['data'][i] + ' ( ' + doc['check'][i] + ' ' + st_params.more_vacancy + ' )' + '</option>';
                                        }
                                    }
                                } else {
                                    if (doc['check'][i] == '1') {
                                        te += '<option value="' + doc['data'][i] + '" ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.a_vacancy + ' )' + '</option>';
                                    } else {
                                        if (doc['check'][i] < 0) {
                                            te += '<option value="' + doc['data'][i] + '" ' + op_disable + '>' + doc['data'][i] + ' ( ' + st_params.no_vacancy + ' )' + '</option>';
                                        } else {
                                            te += '<option value="' + doc['data'][i] + '" ' + op_disable + '>' + doc['data'][i] + ' ( ' + doc['check'][i] + ' ' + st_params.more_vacancy + ' )' + '</option>';
                                        }
                                    }
                                }
                            }
                        }
                    }
                    $('#starttime_tour option').remove();
                    $('#starttime_tour').append(te);
                    overlay.hide();
                } else {
                    $('#starttime_box').parent().hide();
                    overlay.hide();
                }
            },
        });
    }
    $('.search-form-wrapper.slider a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var slideHeight = $('.search-form-wrapper.slider').outerHeight();
        var ft = $('.st-bg-slider').data('fotorama');
        ft.resize({
            height: slideHeight
        });
    });
    $('.st-list-of-multi-services').each(function () {
        var t = $(this);
        var dataTabShowVal = $('.st-list-dropdown .header', t).data('value');
        $('.multi-service-wrapper .tab-content.' + dataTabShowVal, t).show();
        $('.has-matchHeight', t).matchHeight({remove: true});
        $('.has-matchHeight', t).matchHeight();
    });
    $('.st-list-dropdown').each(function () {
        var t = $(this);
        var parent = t.closest('.st-list-of-multi-services');
        var currentTabList = t.find('.header').data('value');
        $('.list', t).find('li[data-value="' + currentTabList + '"]').hide();
        $('.header', t).click(function () {
            $('.list', t).toggle();
        });
        $('.list li', t).click(function () {
            var me = $(this);
            $('.list li', t).removeClass('active');
            me.addClass('active');
            var dataS = me.data('value');
            var dataSName = me.text();
            $('.header span', t).text(dataSName);
            $('.header', t).attr('data-value', dataS);
            me.parent().hide();
            $('.multi-service-wrapper .tab-content', parent).hide();
            $('.multi-service-wrapper .tab-content.' + dataS, parent).show();
            setTimeout(function () {
                $('.multi-service-wrapper .tab-content .has-matchHeight', parent).matchHeight({remove: true});
                $('.multi-service-wrapper .tab-content .has-matchHeight', parent).matchHeight();
            }, 1000);
            $('.list li', t).show();
            $('.list', t).find('li[data-value="' + dataS + '"]').hide();
        })
        $(document).mouseup(function (e) {
            var container = t;
            if (!container.is(e.target) && container.has(e.target).length === 0) {
                container.find('.list').hide();
            }
        });
    });
    if ($('.search-form-wrapper.mix').length > 0) {
        if (window.matchMedia("(max-width: 991px)").matches) {
            var heightTabMix = [];
            $('.search-form-wrapper.mix .tab-content .tab-pane').each(function () {
                var idNameTabMix = $(this).attr('id');
                var tabMixShowEl = document.querySelector('.search-form-wrapper.mix .tab-pane#' + idNameTabMix),
                    tabMixWantedHeight = getHeightHiddenEl(tabMixShowEl);
                heightTabMix.push(tabMixWantedHeight);
            });
            if (heightTabMix.length) {
                var maxHeightTabMix = Math.max.apply(null, heightTabMix);
                var maxHeightPos = heightTabMix.indexOf(maxHeightTabMix);
                $('.search-form-wrapper.mix .tab-content .tab-pane').each(function (i, obj) {
                    if (i === maxHeightPos)
                        $(this).css('height', (maxHeightTabMix - 1) + 'px');
                    else
                        $(this).css('height', maxHeightTabMix + 'px');
                });
            }
        }
    }
})(jQuery);
function initMapContactPage(mapEl) {
    var mapStylesContact = [
        {
            "elementType": "labels",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "administrative",
            "elementType": "geometry",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "administrative.land_parcel",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "administrative.neighborhood",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "poi",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "transit",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        }
    ];
    var mapLat = mapEl.data('lat');
    var mapLng = mapEl.data('lng');
    var map = new google.maps.Map(document.getElementById('contact-map-new'), {
        zoom: 13,
        center: {lat: parseFloat(mapLat), lng: parseFloat(mapLng)},
        disableDefaultUI: true,
        styles: mapStylesContact
    });
    new google.maps.Marker({
        position: new google.maps.LatLng(mapLat, mapLng),
        icon: st_params.icon_contact_map,
        map: map,
    });
}
function customControlGoogleMap(mapEl, map) {
    //==== Top Right area
    var topRightArea = document.createElement('div');
    topRightArea.className = 'google-control-top-right-area';
    var controlFullScreen = document.createElement('div');
    controlFullScreen.className = 'google-control-fullscreen google-custom-control';
    controlFullScreen.innerHTML = '<img src="' + st_list_map_params.icon_full_screen + '" alt="Full Screen"/>';
    topRightArea.appendChild(controlFullScreen);
    var controlCloseFullScreen = document.createElement('div');
    controlCloseFullScreen.className = 'google-control-closefullscreen google-custom-control hide';
    controlCloseFullScreen.innerHTML = '<img src="' + st_list_map_params.icon_close + '" alt="Full Screen"/>';
    topRightArea.appendChild(controlCloseFullScreen);
    var controlMyLocation = document.createElement('div');
    controlMyLocation.className = 'google-control-mylocation google-custom-control';
    controlMyLocation.innerHTML = '<img src="' + st_list_map_params.icon_my_location + '" alt="Full Screen"/>';
    topRightArea.appendChild(controlMyLocation);
    var controlStyles = document.createElement('div');
    controlStyles.className = 'google-control-styles google-custom-control';
    controlStyles.innerHTML = '<img src="' + st_list_map_params.icon_my_style + '" alt="Full Screen"/><div class="google-control-dropdown"><div class="item">Silver</div><div class="item">Retro</div><div class="item">Dark</div><div class="item">Night</div><div class="item">Aubergine</div></div>';
    topRightArea.appendChild(controlStyles);
    //==== Bottom Right area
    var bottomRightArea = document.createElement('div');
    bottomRightArea.className = 'google-control-bottom-right-area';
    var controlZoomIn = document.createElement('div');
    controlZoomIn.className = 'google-control-zoomin google-custom-control';
    controlZoomIn.innerHTML = '<img src="' + st_list_map_params.icon_zoom_in + '" alt="Full Screen"/>';
    bottomRightArea.appendChild(controlZoomIn);
    var controlZoomOut = document.createElement('div');
    controlZoomOut.className = 'google-control-zoomout google-custom-control';
    controlZoomOut.innerHTML = '<img src="' + st_list_map_params.icon_zoom_out + '" alt="Full Screen"/>';
    bottomRightArea.appendChild(controlZoomOut);
    map.controls[google.maps.ControlPosition.RIGHT_TOP].push(topRightArea);
    map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(bottomRightArea);
    controlFullScreen.addEventListener('click', function () {
        controlFullScreen.classList.add('hide');
        controlCloseFullScreen.classList.remove('hide');
        var element = map.getDiv();
        if (element.requestFullscreen) {
            element.requestFullscreen();
        }
        if (element.webkitRequestFullScreen) {
            element.webkitRequestFullScreen();
        }
        if (element.mozRequestFullScreen) {
            element.mozRequestFullScreen();
        }
    });
    controlCloseFullScreen.addEventListener('click', function () {
        controlFullScreen.classList.remove('hide');
        controlCloseFullScreen.classList.add('hide');
        if (document.exitFullscreen) document.exitFullscreen();
        else if (document.webkitExitFullscreen) document.webkitExitFullscreen();
        else if (document.mozCancelFullScreen) document.mozCancelFullScreen();
        else if (document.msExitFullscreen) document.msExitFullscreen();
    });
    controlMyLocation.addEventListener('click', function () {
        if (navigator.geolocation) navigator.geolocation.getCurrentPosition(function (pos) {
            var latlng = new google.maps.LatLng(pos.coords.latitude, pos.coords.longitude);
            map.setCenter(latlng);
            new google.maps.Marker({
                position: latlng,
                icon: mapEl.data().icon,
                map: map
            });
        }, function (error) {
            console.log('Can not get your Location');
        });
    });
    controlZoomIn.addEventListener('click', function () {
        var current = map.getZoom();
        map.setZoom(current + 1);
    });
    controlZoomOut.addEventListener('click', function () {
        var current = map.getZoom();
        map.setZoom(current - 1);
    });
    controlStyles.addEventListener('click', function () {
        controlStyles.querySelector('.google-control-dropdown').classList.toggle('show');
    });
    var dropdownStyles = controlStyles.querySelector('.google-control-dropdown');
    var items = dropdownStyles.querySelectorAll('.item');
    for (var i = 0; i < items.length; i++) {
        items[i].addEventListener('click', function () {
            var style = item.textContent.toLowerCase();
            if (mapStyles[style]) {
                map.setOptions({styles: mapStyles[style]});
            }
        });
    }
}
function initMapDetail(mapEl, mapData, mapLat, mapLng, mapZoom, mapIcon){
    console.log(mapData);
    // var popupPos = mapEl.data('popup-position');
    // if (mapData.length <= 0)
        mapData = mapEl.data('data_show');
    if (mapLat.length <= 0)
        mapLat = mapEl.data('lat');
    if (mapLng.length <= 0)
        mapLng = mapEl.data('lng');
    if (mapZoom.length <= 0)
        mapZoom = 16;
    if (mapIcon.length <= 0)
        mapIcon = mapEl.data('icon');
    var map = new google.maps.Map(document.getElementById('list_map'), {
      zoom: mapZoom,
      center: new google.maps.LatLng(mapLat, mapLng),
      mapTypeId: google.maps.MapTypeId.ROADMAP
    });
    var infowindow = new google.maps.InfoWindow({
        maxWidth: 400,
        maxHeight: 300
    });
    var marker, i;

    if (typeof mapData != 'undefined' && Object.keys(mapData).length) {
        var markers = jQuery.map(mapData, function (location, i) {
            var icon = {
                url: mapData[i].icon_mk,
                size: {
                    width: 40,
                    height: 50
                },
                origin: new google.maps.Point(0,0), // origin
                anchor: new google.maps.Point(0,0) // anchor
               
            };
             marker = new google.maps.Marker({
                position: new google.maps.LatLng(mapData[i].lat, mapData[i].lng), 
                map: map, 
                icon: icon,
                optimized: false
            });

            bounds = new google.maps.LatLngBounds();
            var loc = new google.maps.LatLng(parseFloat(mapData[i].lat), parseFloat(mapData[i].lng));
            bounds.extend(loc);
            var ibOptions = {
                content: '',
                disableAutoPan: true
                , maxWidth: 0
                , zIndex: null
                , boxStyle: {
                    padding: "0px 0px 0px 0px",
                },
                closeBoxURL: "",
                cancelBubble: true,
                infoBoxClearance: new google.maps.Size(1, 1),
                isHidden: false,
                pane: "floatPane",
                enableEventPropagation: true,
                alignBottom: true
            };
            if(i < Object.keys(mapData).length ){
                google.maps.event.addListener(marker, 'click', (function(marker, i) {
                    return function() {
                      infowindow.setContent(mapData[i].content_html);
                      if((mapData[i].lat != mapLat) &&  (mapData[i].lng != mapLng)){
                        infowindow.open(map, marker);
                      }
                      
                    }
                })(marker, i));
            }
            
         });
    }

}
function initHalfMap(mapEl, mapData, mapLat, mapLng, mapZoom, mapIcon) {
    var popupPos = mapEl.data('popup-position');
    if (mapData.length <= 0)
        mapData = mapEl.data('data_show');
    if (mapLat.length <= 0)
        mapLat = mapEl.data('lat');
    if (mapLng.length <= 0)
        mapLng = mapEl.data('lng');
    if (mapZoom.length <= 0)
        mapZoom = mapEl.data('zoom');
    if (mapIcon.length <= 0)
        mapIcon = mapEl.data('icon');
    var map = new google.maps.Map(mapEl.get(0), {
        zoom: mapZoom,
        center: {lat: parseFloat(mapLat), lng: parseFloat(mapLng)},
        disableDefaultUI: true
    });
    bounds = new google.maps.LatLngBounds();
    if (typeof mapData != 'undefined' && Object.keys(mapData).length) {
        var marker = [];
        var ib = [];
        var c = {};
        var markers = jQuery.map(mapData, function (location, i) {
            marker[i] = new google.maps.Marker({
                position: {lat: parseFloat(location.lat), lng: parseFloat(location.lng)},
                options: {
                    icon: mapIcon,
                    animation: google.maps.Animation.DROP
                },
                map: map
            });
            var loc = new google.maps.LatLng(parseFloat(location.lat), parseFloat(location.lng));
            bounds.extend(loc);
            var ibOptions = {
                content: '',
                disableAutoPan: true
                , maxWidth: 0
                , pixelOffset: new google.maps.Size(-135, -55)
                , zIndex: null
                , boxStyle: {
                    padding: "0px 0px 0px 0px",
                    width: "270px",
                },
                closeBoxURL: "",
                cancelBubble: true,
                infoBoxClearance: new google.maps.Size(1, 1),
                isHidden: false,
                pane: "floatPane",
                enableEventPropagation: true,
                alignBottom: true
            };
            if (window.matchMedia("(min-width: 768px)").matches) {
                if (popupPos == 'right') {
                    ibOptions.pixelOffset = new google.maps.Size(35, -208);
                    ibOptions.alignBottom = false;
                }
            }
            jQuery(window).resize(function () {
                if (window.matchMedia("(min-width: 768px)").matches) {
                    if (popupPos == 'right') {
                        ibOptions.pixelOffset = new google.maps.Size(35, -208);
                        ibOptions.alignBottom = false;
                    }
                }
            });
            google.maps.event.addListener(marker[i], 'click', (function () {
                var source = location.content_html;
                var boxText = document.createElement("div");
                if (window.matchMedia("(min-width: 768px)").matches) {
                    if (popupPos == 'right') {
                        boxText.classList.add("right-box");
                    }
                }
                jQuery(window).resize(function () {
                    if (window.matchMedia("(min-width: 768px)").matches) {
                        if (popupPos == 'right') {
                            boxText.classList.add("right-box");
                        }
                    } else {
                        boxText.classList.remove("right-box");
                    }
                });
                boxText.style.cssText = "border-radius: 5px; background: #fff; padding: 0px;";
                boxText.innerHTML = source;
                ibOptions.content = boxText;
                var ks = Object.keys(c);
                if (ks.length) {
                    for (var j = 0; j < ks.length; j++) {
                        c[ks[j]].close();
                    }
                }
                ib[i] = new InfoBox(ibOptions);
                c[i] = ib[i];
                ib[i].open(map, this);
                map.panTo(ib[i].getPosition());
                google.maps.event.addListener(ib[i], 'domready', function () {
                    var closeInfoBox = document.getElementById("close-popup-on-map");
                    google.maps.event.addDomListener(closeInfoBox, 'click', function () {
                        ib[i].close();
                    });
                });
            }));
            return marker[i];
        });
        /*new MarkerClusterer(map, markers,
            {
                styles: [{
                    height   : 36,
                    url      : st_params.mclusmap,
                    width    : 36,
                    textColor: 'white',
                    textSize : '16'
                }, {
                    height   : 36,
                    url      : st_params.mclusmap,
                    width    : 36,
                    textColor: 'white',
                    textSize : '16'
                }, {
                    height   : 36,
                    url      : st_params.mclusmap,
                    width    : 36,
                    textColor: 'white',
                    textSize : '16'
                }]
            });*/
        customControlGoogleMap(mapEl.get(0), map);
    }
    map.fitBounds(bounds);
    map.panToBounds(bounds);
    var listener = google.maps.event.addListener(map, "idle", function () {
        if (map.getZoom() > 16) map.setZoom(16);
        google.maps.event.removeListener(listener);
    });
}
/*Send email all in single service*/
(function ($) {
    'use strict';
    var body = $('body');
    $(".form-st-send-mail .st_send-mail-form").submit(function(e){
        return false;
    });
    $('.form-st-send-mail .st_send-mail-form .sent-email-st').click(function (ev) {
        ev.preventDefault();
        var type_service = $("input[name=type_service]").val();
        var name_service = $("input[name=name_service]").val();
        var name_st = $("input[name=name_st]").val();
        var email_st = $("input[name=email_st]").val();
        var phone_st = $("input[name=phone_st]").val();
        var content_st = $("textarea[name=content_st]").val();
        var email_owl = $("input[name=email_owl]").val();
        $('.st-sent-mail-customer .loader-wrapper').show();
        console.log(content_st);
        $.ajax({
            url: st_params.ajax_url,
            type: "GET",
            data: {
                'action': "st_send_email_single_service",
                'type_service': type_service,
                'name_service': name_service,
                'name_st': name_st,
                'email_st': email_st,
                'phone_st': phone_st,
                'content_st': content_st,
                'email_owl': email_owl
            },
            dataType: "json",
            beforeSend: function () {
            },
            error : function(jqXHR, textStatus, errorThrown) {
                },
            success : function(res){

            },
            complete: function (xhr, status) {

                if(xhr.responseJSON.status != 0){
                    var mess = '<div class="ccv-success"><div class="content-message">'+xhr.responseJSON.message+'</div></div>';
                    $('.form-st-send-mail .st_send-mail-form').html(mess);
                    $('.st-sent-mail-customer .loader-wrapper').hide();
                } else{
                    var mess = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>'+xhr.responseJSON.message+'</div>';
                    $('.form-st-send-mail .message-wrapper-sendemail').html(mess);
                    $('.st-sent-mail-customer .loader-wrapper').hide();
                }
            }
        });
    });
})(jQuery);

(function($) {
    // single hotel room booking ajax
    $('form.hotel-room-booking-form').on('click', 'button.btn-book-ajax', function(e) {
        e.preventDefault();
        var form = $('form.hotel-room-booking-form');
        var data = $('form.hotel-room-booking-form').serializeArray();
        var loadingSubmit = form.find('button[name=submit]');
        $(loadingSubmit).find("i.fa-spin").removeClass("hide");
        data.push({
            name: 'security',
            value: st_params._s
        });
        $('div.message-wrapper').html("");
        $.ajax({
            url: st_params.ajax_url,
            method: "post",
            dataType: 'json',
            data: data,
            beforeSend: function() {
                $('div.message-wrapper').html("");
            },
            success: function(res) {
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
                if (res) {
                    if (res.status) {
                        if (res.redirect) {
                            window.location = res.redirect;
                        }
                    } else {
                        if (res.message) {
                            $('div.message-wrapper').html(res.message);
                        }
                    }
                }
            },
            error: function(err) {
                $('div.message-wrapper').html("");
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
            }
        });
    });

    // activity booking ajax
    $('form.activity-booking-form').on('click', 'button.btn-book-ajax', function(e) {
        e.preventDefault();
        var form = $('form.activity-booking-form');
        var data = $('form.activity-booking-form').serializeArray();
        var loadingSubmit = form.find('button[name=submit]');
        $(loadingSubmit).find("i.fa-spin").removeClass("hide");
        data.push({
            name: 'security',
            value: st_params._s
        });
        $('div.message-wrapper').html("");
        $.ajax({
            url: st_params.ajax_url,
            method: "post",
            dataType: 'json',
            data: data,
            beforeSend: function() {
                $('div.message-wrapper').html("");
            },
            success: function(res) {
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
                if (res) {
                    if (res.status) {
                        if (res.redirect) {
                            window.location = res.redirect;
                        }
                    } else {
                        if (res.message) {
                            $('div.message-wrapper').html(res.message);
                        }
                    }
                }
            },
            error: function(err) {
                $('div.message-wrapper').html("");
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
            }
        });
    });

    // tour booking ajax
    $('form.tour-booking-form').on('click', 'button.btn-book-ajax', function(e) {
        e.preventDefault();
        var form = $('form.tour-booking-form');
        var data = $('form.tour-booking-form').serializeArray();
        var loadingSubmit = form.find('button[name=submit]');
        $(loadingSubmit).find("i.fa-spin").removeClass("hide");
        data.push({
            name: 'security',
            value: st_params._s
        });
        $('div.message-wrapper').html("");
        $.ajax({
            url: st_params.ajax_url,
            method: "post",
            dataType: 'json',
            data: data,
            beforeSend: function() {
                $('div.message-wrapper').html("");
            },
            success: function(res) {
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
                if (res) {
                    if (res.status) {
                        if (res.redirect) {
                            window.location = res.redirect;
                        }
                    } else {
                        if (res.message) {
                            $('div.message-wrapper').html(res.message);
                        }
                    }
                }
            },
            error: function(err) {
                $('div.message-wrapper').html("");
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
            }
        });
    });

    // car booking ajax
    $('form.car-booking-form').on('click', 'button.btn-book-ajax', function(e) {
        e.preventDefault();
        var form = $('form.car-booking-form');
        var data = $('form.car-booking-form').serializeArray();
        var loadingSubmit = form.find('button[name=submit]');
        $(loadingSubmit).find("i.fa-spin").removeClass("hide");
        data.push({
            name: 'security',
            value: st_params._s
        });
        $('div.message-wrapper').html("");
        $.ajax({
            url: st_params.ajax_url,
            method: "post",
            dataType: 'json',
            data: data,
            beforeSend: function() {
                $('div.message-wrapper').html("");
            },
            success: function(res) {
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
                if (res) {
                    if (res.status) {
                        if (res.redirect) {
                            window.location = res.redirect;
                        }
                    } else {
                        if (res.message) {
                            $('div.message-wrapper').html(res.message);
                        }
                    }
                }
            },
            error: function(err) {
                $('div.message-wrapper').html("");
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
            }
        });
    });

    // rental booking ajax
    $('form.rental-booking-form').on('click', 'button.btn-book-ajax', function(e) {
        e.preventDefault();
        var form = $('form.rental-booking-form');
        var data = $('form.rental-booking-form').serializeArray();
        var loadingSubmit = form.find('button[name=submit]');
        $(loadingSubmit).find("i.fa-spin").removeClass("hide");
        data.push({
            name: 'security',
            value: st_params._s
        });
        $('div.message-wrapper').html("");
        $.ajax({
            url: st_params.ajax_url,
            method: "post",
            dataType: 'json',
            data: data,
            beforeSend: function() {
                $('div.message-wrapper').html("");
            },
            success: function(res) {
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
                if (res) {
                    if (res.status) {
                        if (res.redirect) {
                            window.location = res.redirect;
                        }
                    } else {
                        if (res.message) {
                            $('div.message-wrapper').html(res.message);
                        }
                    }
                }
            },
            error: function(err) {
                $('div.message-wrapper').html("");
                $(loadingSubmit).find('i.fa-spin').addClass("hide");
            }
        });
    });

    jQuery(".dropdown-menu.st-icheck").niceScroll({
    });

})(jQuery);
