<?php
if ($number < 0) {
    $number = 'all';
}
$args = array(
    'taxonomy' => 'st_tour_type',
    'hide_empty' => false,
    'number' => $number

);
if (!empty($category_ids)) {
    $args['include'] = explode(',', $category_ids);
}
$query = get_terms($args);
$result_page = '';
$result_page = get_the_permalink(st_get_page_search_result('st_tours'));
?>
<div class="category-slider-wrapper">
    <div class="category-slider owl-carousel ">
        <?php foreach ($query as $value) {

            $tour_style_id = $value->term_id;

            $result_page = add_query_arg(['taxonomy[st_tour_type]' => $tour_style_id], $result_page);
            $imageID = get_term_meta($value->term_id, 'st_tour_type_image');
            $imageUrl = wp_get_attachment_image_url($imageID[0], array(540,740));
            ?>
            <div class="category-item">
                <div class="thumb">
                    <?php if (!empty($imageUrl)) { ?>
                    <a href="<?php echo esc_url($result_page) ?>"><img src="<?php echo esc_url($imageUrl) ?> " alt="<?php echo get_bloginfo('description') ?>"></a>
                    <?php } ?>
                    <span class="st-title"><?php echo esc_html($value->name) ?></span>
                </div>
            </div>
        <?php } ?>
    </div>
</div>

