<?php
/**
 * Created by wpbooking.
 * Developer: nasanji
 * Date: 12/23/2016
 * Version: 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if(!class_exists('WB_Form_Builder_Image_Upload')){
    class WB_Form_Builder_Image_Upload extends WB_Form_Builder_Abstract_fields{

        static $_inst = false;

        protected $field_id = 'image_upload';
        protected $field_group = 'advance';

        function __construct()
        {


            parent::__construct();
        }
        public function get_field_settings()
        {
            $this->field_settings = array(
                array(
                    'id' => 'title',
                    'label' => esc_html__('Title',ST_TEXTDOMAIN),
                    'type' => 'text',
                    'require' => true
                ),
                array(
                    'id' => 'name',
                    'label' => esc_html__('Name',ST_TEXTDOMAIN),
                    'type' => 'text',
                    'desc' => esc_html__('The name in input tag:',ST_TEXTDOMAIN).' &lt;input type="text" <strong>name</strong>="field_name" &gt;',
                    'require' => true
                ),
                array(
                    'id' => 'required',
                    'label' => esc_html__('Required',ST_TEXTDOMAIN),
                    'type' => 'checkbox',
                ),
                array(
                    'id' => 'advance',
                    'label' => esc_html__('Advanced Options',ST_TEXTDOMAIN),
                    'type' => 'link',
                ),
                array(
                    'id' => 'desc',
                    'label' => esc_html__('Description (optional)',ST_TEXTDOMAIN),
                    'type' => 'text',
                    'adv_field' => true
                ),
                array(
                    'id' => 'extra_class',
                    'label' => esc_html__('Extra Class (optional)',ST_TEXTDOMAIN),
                    'type' => 'text',
                    'adv_field' => true
                ),
                array(
                    'id' => 'custom_id',
                    'label' => esc_html__('Custom Field ID (optional)',ST_TEXTDOMAIN),
                    'type' => 'text',
                    'adv_field' => true
                )

            );

            return parent::get_field_settings(); // TODO: Change the autogenerated stub
        }

        public function get_info($key)
        {
            $this->field_info = array(
                'title' => esc_html__('Media Upload',ST_TEXTDOMAIN),
                'desc' => esc_html__('Media upload field',ST_TEXTDOMAIN)
            );
            return parent::get_info($key); // TODO: Change the autogenerated stub
        }

        function get_frontend_html($data)
        {
            parent::get_frontend_html($data); // TODO: Change the autogenerated stub

            wp_enqueue_media();

            $html = '<div class="form-group '.$data['class'].' wb-upload-fields">
                        <label for="' . $data['custom_id'] . '">' . $data['label'] . ' ' . (($data['required']) ? '<span class="required">*</span>' : '') . '</label>
                        <a class="wb-btn wb-btn-default wb-btn-sm wb-upload-image" href="#">'.esc_html__('Upload',ST_TEXTDOMAIN).'</a>
                        <input type="hidden" id="'.$data['custom_id'].'" class="wb-upload-image-save" name="'.$data['name'].'" value="" />
                        <div class="wb-load-image"></div>
                        <span class="desc">'.$data['desc'].'</span>
                    </div>';
            return $html;
        }

        function get_admin_html($data, $order_id){
            parent::get_admin_html($data, $order_id);
            $value = isset( $_POST[ $data['name']] ) ? $_POST[ $data['name'] ] : get_post_meta( $order_id, $data['name'], true );

            wp_enqueue_media();
            $size_image = apply_filters('st_form_builder_custommer_image_size', 'thumbnail');
	        $type = get_post_mime_type($value);

	        $text_info = '';
	        switch ($type) {
		        case 'application/zip':
		        case 'application/javascript':
			        $text_info .= '<div class="download-file"><a download href="'. wp_get_attachment_url($value) .'"><i class="fa fa-download" aria-hidden="true"></i></a></div> ';
			        break;
		        default:
			        break;
	        }

            $html = '<div class="form-row wb-upload-fields admin-upload-fields">
                        <label class="form-label"
                               for="' . $data['custom_id'] . '">' . $data['label'] . ' ' . (($data['required']) ? '<span class="required">*</span>' : '') . '</label>
                        <div class="controls">
                            <a class="wb-btn wb-btn-default wb-btn-sm wb-upload-image" href="#">'.esc_html__('Upload',ST_TEXTDOMAIN).'</a>
                            <input type="hidden" id="'.$data['custom_id'].'" class="wb-upload-image-save" name="'.$data['name'].'" value="'.$value.'" />
                            <div class="wb-load-image">' . $text_info . wp_get_attachment_image($value, $size_image, true, array('class' => 'frontend-image img-responsive')).'<a class="delete" href="javascript:void(0);">&times;</a></div>
                        </div>
                    </div>';
            return $html;
        }

        static function inst()
        {
            if (!self::$_inst)
                self::$_inst = new self();

            return self::$_inst;
        }

    }
    WB_Form_Builder_Image_Upload::inst();
}