<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_PayuMoney_Payment_Gateway')) {
    class ST_PayuMoney_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gateway_id = 'st_payumoney';

        private $keyID;
        private $keySecret;
        private $url;
        private $serviceProvider;

        function __construct()
        {
            add_filter('st_payment_gateway_st_payumoney_name', array($this, 'get_name'));

        }

        function get_option_fields()
        {
            return array(
                [
                    'id' => 'test_mode_payumoney',
                    'label' => esc_html__('Test Mode', 'traveler-payumoney'),
                    'type' => 'on-off',
                    'std' => 'on',
                    'desc' => esc_html__('Using for PayuMoney sanbox account', 'traveler-payumoney'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'merchant_key_payumoney',
                    'label' => esc_html__('Merchant Key', 'traveler-payumoney'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your Merchant Key', 'traveler-payumoney'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'merchant_salt_payumoney',
                    'label' => esc_html__('Merchant Salt', 'traveler-payumoney'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your Merchant Salt', 'traveler-payumoney'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'service_provider_payumoney',
                    'label' => esc_html__('Provider', 'traveler-payumoney'),
                    'type' => 'select',
                    'choices' => [
                        [
                            'label' => esc_html__('PayUmoney', 'traveler-payumoney'),
                            'value' => 'money'
                        ],
                        [
                            'label' => esc_html__('PayuBiz', 'traveler-payumoney'),
                            'value' => 'biz'
                        ],
                    ],
                    'std' => 'money',
                    'section' => 'option_pmgateway'
                ],
            );
        }

        function _pre_checkout_validate()
        {
            return true;
        }

        public function setDefaultParams()
        {
            $this->keyID = st()->get_option('merchant_key_payumoney');
            $this->keySecret = st()->get_option('merchant_salt_payumoney');
            $testMode = st()->get_option('test_mode_payumoney', 'on');
            if ($testMode == 'on') {
                $this->url = 'https://sandboxsecure.payu.in/_payment';
            } else {
                $this->url = 'https://secure.payu.in/_payment';
            }

            $this->serviceProvider = st()->get_option('service_provider_payumoney', 'money');
        }

        public function getForm($order_id)
        {
            $this->setDefaultParams();
            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);

            $productinfo = "Order $order_id";
            $firstname = get_post_meta($order_id, 'st_first_name', true);
            $lastname = get_post_meta($order_id, 'st_last_name', true);
            $phone = get_post_meta($order_id, 'st_phone', true);
            $email = get_post_meta($order_id, 'st_email', true);
            $address = get_post_meta($order_id, 'st_address', true);
            $txnid = $order_id . '_' . date("ymds");
            $str = "$this->keyID|$txnid|$total|$productinfo|$firstname|$email|$order_id||||||||||$this->keySecret";
            $hash = strtolower(hash('sha512', $str));

            if ('biz' == $this->serviceProvider) {
                $service_provider = '';
            } else {
                $service_provider = 'payu_paisa';
            }

            $payuindia_args = array(
                'key' => $this->keyID,
                'hash' => $hash,
                'txnid' => $txnid,
                'amount' => $total,
                'firstname' => $firstname,
                'email' => $email,
                'phone' => substr($phone, -10),
                'productinfo' => $productinfo,
                'surl' => $this->get_return_url($order_id),
                'furl' => $this->get_return_url($order_id),
                'lastname' => $lastname,
                'address1' => $address,
                'address2' => $address,
                'city' => get_post_meta($order_id, 'st_city', true),
                'state' => get_post_meta($order_id, 'st_province', true),
                'country' => get_post_meta($order_id, 'st_country', true),
                'zipcode' => get_post_meta($order_id, 'st_zip_code', true),
                'curl' => $this->get_return_url($order_id),
                'pg' => 'NB',
                'udf1' => $order_id,
                'service_provider' => $service_provider
            );
            $payuindia_args_array = array();
            foreach ($payuindia_args as $key => $value) {
                $payuindia_args_array[] = "<input type='hidden' name='$key' value='$value'/>";
            }

            return '	<form action="' . $this->url . '" method="post" id="payuindia_payment_form">
  				' . implode('', $payuindia_args_array) .
                '<script type="text/javascript">
					document.getElementById("payuindia_payment_form").submit();
					</script>
				</form>';
        }

        function do_checkout($order_id)
        {
            $this->setDefaultParams();

            try {
                $form = $this->getForm($order_id);

                return [
                    'status' => true,
                    'redirect_form' => $form
                ];
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => sprintf(esc_html__('Error code: %s', 'traveler-payumoney'), $e->getMessage())
                ];
            }
        }

        function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-payumoney')];
            }
            $this->setDefaultParams();

            try {
                $order = STAdminPackages::get_inst()->get('*', $order_id);
                $total = round((float)$order->package_price, 2);

                $productinfo = "Member Ship $order_id";
                $firstname = STInput::post('st_first_name', true);
                $lastname = STInput::post('st_last_name', true);
                $phone = STInput::post('st_phone', true);
                $email = STInput::post('st_email', true);
                $address = STInput::post('st_address', 'Address');
                $txnid = $order_id . '_' . date("ymds");
                $str = "$this->keyID|$txnid|$total|$productinfo|$firstname|$email|$order_id||||||||||$this->keySecret";
                $hash = strtolower(hash('sha512', $str));

                if ('biz' == $this->serviceProvider) {
                    $service_provider = '';
                } else {
                    $service_provider = 'payu_paisa';
                }

                $payuindia_args = array(
                    'key' => $this->keyID,
                    'hash' => $hash,
                    'txnid' => $txnid,
                    'amount' => $total,
                    'firstname' => $firstname,
                    'email' => $email,
                    'phone' => substr($phone, -10),
                    'productinfo' => $productinfo,
                    'surl' => STAdminPackages::get_inst()->get_return_url($order_id),
                    'furl' => STAdminPackages::get_inst()->get_return_url($order_id),
                    'lastname' => $lastname,
                    'address1' => $address,
                    'address2' => $address,
                    'city' => STInput::post('st_city', 'HN'),
                    'state' => STInput::post('st_province', 'HN'),
                    'country' => STInput::post('st_country', 'VN'),
                    'zipcode' => STInput::post('st_zip_code', '10000'),
                    'curl' => STAdminPackages::get_inst()->get_return_url($order_id),
                    'pg' => 'NB',
                    'udf1' => $order_id,
                    'service_provider' => $service_provider
                );
                $payuindia_args_array = array();
                foreach ($payuindia_args as $key => $value) {
                    $payuindia_args_array[] = "<input type='hidden' name='$key' value='$value'/>";
                }

                $form = '	<form action="' . $this->url . '" method="post" id="payuindia_payment_form">
  				' . implode('', $payuindia_args_array) .
                    '<script type="text/javascript">
					document.getElementById("payuindia_payment_form").submit();
					</script>
				</form>';

                return [
                    'status' => TravelHelper::st_encrypt( $order_id . 'st1' ),
                    'redirect_form' => $form
                ];
            } catch (\Exception $e) {
                return [
                    'status' => TravelHelper::st_encrypt( $order_id . 'st0' ),
                    'message' => sprintf(esc_html__('Error code: %s', 'traveler-payumoney'), $e->getMessage())
                ];
            }
        }

        function check_complete_purchase($order_id)
        {
            if (isset($_REQUEST['txnid']) && isset($_REQUEST['mihpayid'])) {
                $order_id = $_REQUEST['udf1'];
                if ($order_id != '') {
                    $this->setDefaultParams();
                    try {
                        $statusOrder = get_post_meta($order_id, 'status', true);
                        $hash = $_REQUEST['hash'];
                        $status = $_REQUEST['status'];
                        $check = "$this->keySecret|$_REQUEST[status]||||||||||$_REQUEST[udf1]|$_REQUEST[email]|$_REQUEST[firstname]|$_REQUEST[productinfo]|$_REQUEST[amount]|$_REQUEST[txnid]|$this->keyID";
                        if ($_REQUEST['additionalCharges']) {
                            $check = $_REQUEST['additionalCharges'] . '|' . $check;
                        }
                        $checkhash = hash('sha512', $check);

                        if ('completed' !== $statusOrder) {
                            if ($hash == $checkhash) {
                                $status = strtolower($status);
                                if ('success' == $status) {
                                    if ('pending' == $statusOrder) {
                                        return [
                                            'status' => false
                                        ];
                                    } else {
                                        return [
                                            'status' => true
                                        ];
                                    }
                                } else if ('pending' == $status) {
                                    return [
                                        'status' => false
                                    ];
                                } else {
                                    return [
                                        'status' => false,
                                        'message' => __('Thank you for the order. However, the transaction has been declined.', 'traveler-payumoney')
                                    ];
                                }
                            } else {
                                return [
                                    'status' => false,
                                    'message' => __('Security Error. Illegal access detected.', 'traveler-payumoney')
                                ];
                            }
                        }
                    } catch (Exception $e) {
                        return [
                            'status' => false,
                            'message' => $e->getMessage()
                        ];
                    }
                }
            }
        }

        function package_completed_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }
            if (isset($_REQUEST['txnid']) && isset($_REQUEST['mihpayid'])) {
                $order_id = $_REQUEST['udf1'];
                if ($order_id != '') {
                    $this->setDefaultParams();
                    try {
                        $order = STAdminPackages::get_inst()->get('*', $order_id);

                        $statusOrder = $order->status;
                        $hash = $_REQUEST['hash'];
                        $status = $_REQUEST['status'];
                        $check = "$this->keySecret|$_REQUEST[status]||||||||||$_REQUEST[udf1]|$_REQUEST[email]|$_REQUEST[firstname]|$_REQUEST[productinfo]|$_REQUEST[amount]|$_REQUEST[txnid]|$this->keyID";
                        if (isset($_REQUEST['additionalCharges'])) {
                            $check = $_REQUEST['additionalCharges'] . '|' . $check;
                        }
                        $checkhash = hash('sha512', $check);

                        if ('completed' !== $statusOrder) {
                            if ($hash == $checkhash) {
                                $status = strtolower($status);
                                if ('success' == $status) {
                                    if ('pending' == $statusOrder) {
                                        return false;
                                    } else {
                                        return true;
                                    }
                                } else if ('pending' == $status) {
                                    return false;
                                } else {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        }
                    } catch (Exception $e) {
                        return false;
                    }
                }
            }
        }

        function is_check_complete_required()
        {
            return true;
        }

        function html()
        {
            echo Traveler_PayuMoney_Payment::get_inst()->loadTemplate('payumoney');
        }

        function get_name()
        {
            return __('PayUMoney', 'traveler-payumoney');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_payumoney_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('merchant_key_payumoney')) {
                    return false;
                }
                if (!st()->get_option('merchant_salt_payumoney')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_payumoney', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function get_logo()
        {
            return Traveler_PayuMoney_Payment::get_inst()->pluginUrl . 'assets/img/pu-logo.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_payumoney'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_PayuMoney_Payment_Gateway', 'add_payment'));
}